/*
 * Decompiled with CFR 0.152.
 */
package test.icecaptools;

import icecaptools.HVMLoadedProperties;
import icecaptools.HVMProperties;
import icecaptools.compiler.NoDuplicatesMemorySegment;
import icecaptools.compiler.aot.LevelNRegisterAllocator;
import icecaptools.compiler.aot.SPManipulator;
import icecaptools.compiler.aot.StackManager;
import org.junit.Assert;
import org.junit.Test;
import test.icecaptools.DefaultSPManipulator;

public class TestLevelNRegisterAllocator {
    @Test
    public void testLevel1RegisterAllocator() {
        StringBuffer output = new StringBuffer();
        HVMLoadedProperties props = new HVMLoadedProperties(System.getProperties());
        NoDuplicatesMemorySegment localVars = new NoDuplicatesMemorySegment((HVMProperties)props);
        LevelNRegisterAllocator regAlloc = new LevelNRegisterAllocator(output, localVars, 1, 1, false, (SPManipulator)new DefaultSPManipulator());
        regAlloc.push(1, "42");
        regAlloc.push(1, "43");
        regAlloc.push(2, "44");
        regAlloc.push(3, "45");
        regAlloc.push(3, "46");
        output.append("   x = " + regAlloc.peekTop(1, 3) + ";\n");
        output.append("   x = " + regAlloc.peekTop(2, 3) + ";\n");
        output.append("   x = " + regAlloc.peekTop(3, 2) + ";\n");
        regAlloc.pop("   x", 3);
        regAlloc.pop("   x", 3);
        regAlloc.pop("   x", 2);
        regAlloc.pop("   x", 1);
        regAlloc.pop("   x", 1);
        regAlloc.push(3, "46");
        regAlloc.pop("   x", 3);
    }

    @Test
    public void testLevel1RegisterAllocatorIsCached() {
        StringBuffer output = new StringBuffer();
        HVMLoadedProperties props = new HVMLoadedProperties(System.getProperties());
        NoDuplicatesMemorySegment localVars = new NoDuplicatesMemorySegment((HVMProperties)props);
        LevelNRegisterAllocator regAlloc = new LevelNRegisterAllocator(output, localVars, 5, 5, false, (SPManipulator)new DefaultSPManipulator());
        Assert.assertFalse((boolean)regAlloc.isCached(0));
        Assert.assertFalse((boolean)regAlloc.isCached(1));
        regAlloc.push(1, "42");
        Assert.assertTrue((boolean)regAlloc.isCached(0));
        Assert.assertFalse((boolean)regAlloc.isCached(1));
        regAlloc.push(1, "43");
        Assert.assertTrue((boolean)regAlloc.isCached(0));
        Assert.assertTrue((boolean)regAlloc.isCached(1));
        regAlloc.push(2, "44");
        regAlloc.push(3, "45");
        regAlloc.push(3, "46");
        Assert.assertTrue((boolean)regAlloc.isCached(0));
        Assert.assertTrue((boolean)regAlloc.isCached(1));
        regAlloc.pop("   x", 3);
        regAlloc.pop("   x", 3);
        regAlloc.pop("   x", 2);
        Assert.assertTrue((boolean)regAlloc.isCached(0));
        Assert.assertTrue((boolean)regAlloc.isCached(1));
        regAlloc.pop("   x", 1);
        Assert.assertTrue((boolean)regAlloc.isCached(0));
        Assert.assertFalse((boolean)regAlloc.isCached(1));
        regAlloc.pop("   x", 1);
        Assert.assertFalse((boolean)regAlloc.isCached(0));
        Assert.assertFalse((boolean)regAlloc.isCached(1));
    }

    @Test
    public void testLevel1RegisterAllocatorFlush() {
        StringBuffer output = new StringBuffer();
        HVMLoadedProperties props = new HVMLoadedProperties(System.getProperties());
        NoDuplicatesMemorySegment localVars = new NoDuplicatesMemorySegment((HVMProperties)props);
        LevelNRegisterAllocator regAlloc = new LevelNRegisterAllocator(output, localVars, 1, 1, false, (SPManipulator)new DefaultSPManipulator());
        regAlloc.push(1, "42");
        regAlloc.push(1, "43");
        regAlloc.push(2, "44");
        regAlloc.push(3, "45");
        regAlloc.push(3, "46");
        regAlloc.flush(true);
    }

    @Test
    public void testLevel2RegisterAllocator1() {
        StringBuffer output = new StringBuffer();
        HVMLoadedProperties props = new HVMLoadedProperties(System.getProperties());
        NoDuplicatesMemorySegment localVars = new NoDuplicatesMemorySegment((HVMProperties)props);
        LevelNRegisterAllocator regAlloc = new LevelNRegisterAllocator(output, localVars, 2, 1, false, (SPManipulator)new DefaultSPManipulator());
        regAlloc.push(1, "42");
        regAlloc.push(1, "43");
        regAlloc.push(2, "44");
        regAlloc.pop("   x", 2);
        regAlloc.pop("   x", 1);
        regAlloc.pop("   x", 1);
    }

    @Test
    public void testLevel2RegisterAllocator2() {
        StringBuffer output = new StringBuffer();
        HVMLoadedProperties props = new HVMLoadedProperties(System.getProperties());
        NoDuplicatesMemorySegment localVars = new NoDuplicatesMemorySegment((HVMProperties)props);
        LevelNRegisterAllocator regAlloc = new LevelNRegisterAllocator(output, localVars, 2, 1, false, (SPManipulator)new DefaultSPManipulator());
        regAlloc.push(3, "42");
        regAlloc.push(1, "43");
        regAlloc.push(1, "44");
    }

    @Test
    public void testLevel2RegisterAllocatorFlush() {
        StringBuffer output = new StringBuffer();
        HVMLoadedProperties props = new HVMLoadedProperties(System.getProperties());
        NoDuplicatesMemorySegment localVars = new NoDuplicatesMemorySegment((HVMProperties)props);
        LevelNRegisterAllocator regAlloc = new LevelNRegisterAllocator(output, localVars, 2, 1, false, (SPManipulator)new DefaultSPManipulator());
        regAlloc.push(1, "42");
        regAlloc.push(1, "43");
        regAlloc.push(2, "44");
        regAlloc.flush(true);
    }

    @Test
    public void testCopy() {
        StringBuffer output = new StringBuffer();
        HVMLoadedProperties props = new HVMLoadedProperties(System.getProperties());
        NoDuplicatesMemorySegment localVars = new NoDuplicatesMemorySegment((HVMProperties)props);
        LevelNRegisterAllocator regAlloc = new LevelNRegisterAllocator(output, localVars, 3, 1, false, (SPManipulator)new DefaultSPManipulator());
        regAlloc.push(1, "42");
        regAlloc.push(1, "43");
        regAlloc.push(2, "44");
        LevelNRegisterAllocator copy = (LevelNRegisterAllocator)regAlloc.copy();
        StringBuffer copyOutput = new StringBuffer();
        copy.setOutput(copyOutput);
        StringBuffer thisOutput = new StringBuffer();
        regAlloc.setOutput(thisOutput);
        copy.flush(true);
        regAlloc.flush(true);
        Assert.assertEquals((Object)copyOutput.toString(), (Object)thisOutput.toString());
    }

    @Test
    public void testEquals() {
        StringBuffer output = new StringBuffer();
        HVMLoadedProperties props = new HVMLoadedProperties(System.getProperties());
        NoDuplicatesMemorySegment localVars = new NoDuplicatesMemorySegment((HVMProperties)props);
        LevelNRegisterAllocator regAlloc = new LevelNRegisterAllocator(output, localVars, 3, 1, false, (SPManipulator)new DefaultSPManipulator());
        regAlloc.push(1, "42");
        regAlloc.push(1, "43");
        regAlloc.push(2, "44");
        LevelNRegisterAllocator copy = (LevelNRegisterAllocator)regAlloc.copy();
        Assert.assertTrue((boolean)regAlloc.equals((Object)copy));
        copy.push(1, "1");
        Assert.assertFalse((boolean)regAlloc.equals((Object)copy));
    }

    @Test
    public void testMerge() {
        StringBuffer output1 = new StringBuffer();
        StringBuffer output2 = new StringBuffer();
        HVMLoadedProperties props = new HVMLoadedProperties(System.getProperties());
        NoDuplicatesMemorySegment localVars = new NoDuplicatesMemorySegment((HVMProperties)props);
        LevelNRegisterAllocator stack1 = new LevelNRegisterAllocator(output1, localVars, 2, 1, false, (SPManipulator)new DefaultSPManipulator());
        LevelNRegisterAllocator stack2 = new LevelNRegisterAllocator(output2, localVars, 2, 1, false, (SPManipulator)new DefaultSPManipulator());
        stack1.push(3, "42");
        Assert.assertFalse((boolean)stack1.equals((Object)stack2));
        try {
            stack1.merge((StackManager)stack2);
            Assert.assertTrue((boolean)stack1.equals((Object)stack2));
        }
        catch (Exception exception) {
            Assert.fail();
        }
        stack2.push(3, "42");
        Assert.assertFalse((boolean)stack1.equals((Object)stack2));
        try {
            stack1.merge((StackManager)stack2);
            Assert.assertTrue((boolean)stack1.equals((Object)stack2));
        }
        catch (Exception exception) {
            Assert.fail();
        }
    }
}

