/*
 * Decompiled with CFR 0.152.
 */
package test.icecaptools;

import icecaptools.AnalysisObserver;
import icecaptools.DefaultObserver;
import icecaptools.MethodOrFieldDesc;
import icecaptools.RestartableMethodObserver;
import icecaptools.compiler.DefaultMethodObserver;
import icecaptools.compiler.ICompilationRegistry;
import icecaptools.compiler.VirtualTable;
import icecaptools.conversion.Converter;
import junit.framework.TestCase;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.ClassPath;
import org.apache.bcel.util.Repository;
import org.apache.bcel.util.SyntheticRepository;
import test.icecaptools.DefaultCompilationRegistry;

public class TestConverter
extends TestCase {
    public void testCreateVTable() throws Exception {
        Converter converter = new Converter(System.out, (RestartableMethodObserver)new DefaultMethodObserver(), (ICompilationRegistry)new DefaultCompilationRegistry(), false);
        ClassPath classPath = new ClassPath("C:\\home\\workspace\\icecaptools\\bin");
        SyntheticRepository repository = SyntheticRepository.getInstance((ClassPath)classPath);
        org.apache.bcel.Repository.setRepository((Repository)repository);
        TestObserver observer = new TestObserver();
        converter.setObserver((AnalysisObserver)observer);
        VirtualTable vtableSub2 = VirtualTable.createVTable((String)"test.icecaptools.minitests.Sub2", (AnalysisObserver)observer);
        VirtualTable vtableSub6 = VirtualTable.createVTable((String)"test.icecaptools.minitests.Sub6", (AnalysisObserver)observer);
        MethodOrFieldDesc methodDesc = new MethodOrFieldDesc("test.icecaptools.minitests.Sub2", "foo", "()V");
        short index1 = vtableSub2.getIndexOf(methodDesc);
        methodDesc = new MethodOrFieldDesc("test.icecaptools.minitests.Sub6", "foo", "()V");
        short index2 = vtableSub6.getIndexOf(methodDesc);
        TestConverter.assertEquals((int)index1, (int)index2);
    }

    public void testBug1() {
        ClassPath classPath = new ClassPath("C:\\home\\workspace\\icecaptools\\bin");
        SyntheticRepository repository = SyntheticRepository.getInstance((ClassPath)classPath);
        org.apache.bcel.Repository.setRepository((Repository)repository);
        try {
            JavaClass clazz = org.apache.bcel.Repository.lookupClass((String)"java.net.InetAddress");
            TestObserver observer = new TestObserver();
            Converter converter = new Converter(System.out, (RestartableMethodObserver)new DefaultMethodObserver(), (ICompilationRegistry)new DefaultCompilationRegistry(), false);
            converter.setObserver((AnalysisObserver)observer);
            converter.convertByteCode(null, clazz, "<clinit>", "()V", true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            TestConverter.fail();
        }
        catch (Exception exception) {
            TestConverter.fail();
        }
    }

    public void testBug2() {
        ClassPath classPath = new ClassPath("C:\\home\\workspace\\icecaptools\\bin");
        SyntheticRepository repository = SyntheticRepository.getInstance((ClassPath)classPath);
        org.apache.bcel.Repository.setRepository((Repository)repository);
        try {
            JavaClass clazz = org.apache.bcel.Repository.lookupClass((String)"java.util.ResourceBundle");
            TestObserver observer = new TestObserver();
            Converter converter = new Converter(System.out, (RestartableMethodObserver)new DefaultMethodObserver(), (ICompilationRegistry)new DefaultCompilationRegistry(), false);
            converter.setObserver((AnalysisObserver)observer);
            converter.convertByteCode(null, clazz, "getClassContext", "()[Ljava/lang/Class;", true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            TestConverter.fail();
        }
        catch (Exception exception) {
            TestConverter.fail();
        }
    }

    public static class TestObserver
    extends DefaultObserver {
        public boolean isMethodUsed(String className, String targetMethodName, String targetMethodSignature) {
            return true;
        }
    }
}

