/*
 * Decompiled with CFR 0.152.
 */
package test.icecaptools;

import icecaptools.AnalysisObserver;
import icecaptools.CompilationSequence;
import icecaptools.DefaultObserver;
import icecaptools.IcecapProgressMonitor;
import icecaptools.RestartableMethodObserver;
import icecaptools.compiler.DefaultIcecapCodeFormatter;
import icecaptools.compiler.DefaultIcecapProgressMonitor;
import icecaptools.compiler.DefaultMethodObserver;
import icecaptools.compiler.ICompilationRegistry;
import icecaptools.compiler.IDGenerator;
import icecaptools.compiler.IcecapCodeFormatter;
import icecaptools.compiler.VirtualTable;
import icecaptools.conversion.ConversionConfiguration;
import icecaptools.conversion.Converter;
import java.io.File;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.ClassPath;
import org.apache.bcel.util.Repository;
import org.apache.bcel.util.SyntheticRepository;
import org.junit.Assert;
import org.junit.Test;
import test.icecaptools.DefaultCompilationRegistry;

public class TestCompiler {
    @Test
    public void testFullCompilation() {
        ConversionConfiguration config = new ConversionConfiguration();
        config.setClassPath("/home/skr/icecapvm/tools/bin");
        config.setInputPackage("test");
        config.setInputClass("TestI2B");
        CompilationSequence sequencer = new CompilationSequence();
        config.setCodeFormatter((IcecapCodeFormatter)new DefaultIcecapCodeFormatter());
        try {
            sequencer.startCompilation(System.out, (RestartableMethodObserver)new DefaultMethodObserver(), config, (IcecapProgressMonitor)new DefaultIcecapProgressMonitor(), (ICompilationRegistry)new DefaultCompilationRegistry(), "", true);
        }
        catch (Throwable throwable) {
            Assert.fail();
        }
        File classesFile = new File("classes.c");
        Assert.assertTrue((boolean)classesFile.exists());
        Assert.assertTrue((classesFile.length() > 0L ? 1 : 0) != 0);
        classesFile.delete();
        classesFile = null;
        File methodsFile = new File("methods.c");
        Assert.assertTrue((boolean)methodsFile.exists());
        Assert.assertTrue((methodsFile.length() > 0L ? 1 : 0) != 0);
        methodsFile.delete();
        methodsFile = null;
    }

    @Test
    public void testVTable() throws Exception {
        ClassPath classPath = new ClassPath("/home/skr/icecapvm/tools/bin");
        SyntheticRepository repository = SyntheticRepository.getInstance((ClassPath)classPath);
        org.apache.bcel.Repository.setRepository((Repository)repository);
        JavaClass clazz = org.apache.bcel.Repository.lookupClass((String)"test.icecaptools.minitests.Sub2");
        DefaultObserver observer = new DefaultObserver();
        Converter converter = new Converter(System.out, (RestartableMethodObserver)new DefaultMethodObserver(), (ICompilationRegistry)new DefaultCompilationRegistry(), false);
        converter.setObserver((AnalysisObserver)observer);
        VirtualTable vtable = VirtualTable.createVTable((String)clazz.getClassName(), (AnalysisObserver)observer);
        System.out.println(vtable.toString());
    }

    @Test
    public void testMethoID() {
        IDGenerator idGen = new IDGenerator();
        String className = "java.util.HashMap";
        String methodName = "<init>";
        String signature = "()V";
        String id1 = idGen.getUniqueId(className, methodName, signature);
        className = "java.util.HashMap";
        methodName = "init";
        signature = "()V";
        String id2 = idGen.getUniqueId(className, methodName, signature);
        Assert.assertFalse((boolean)id1.equals(id2));
    }
}

