/*
 * Decompiled with CFR 0.152.
 */
package test.icecaptools;

import icecaptools.BNode;
import icecaptools.BasicBNode;
import icecaptools.stackanalyser.ProducerConsumerCellInfo;
import icecaptools.stackanalyser.ProducerConsumerStack;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class TestAnnotationStack {
    @Test
    public void testAnnotationStack1() {
        ProducerConsumerStack stack = new ProducerConsumerStack();
        BasicBNode testNode = new BasicBNode(0, "locationClass", "locationMethod", "locationMethodSignature");
        try {
            stack.push((BNode)testNode);
            stack.push((BNode)testNode);
            stack.push((BNode)testNode);
            stack.push((BNode)testNode);
        }
        catch (Exception exception) {
            Assert.fail();
        }
        Assert.assertEquals((long)4L, (long)stack.size());
    }

    @Test
    public void testAnnotationStack2() {
        ProducerConsumerStack stack = new ProducerConsumerStack();
        BasicBNode testNode1 = new BasicBNode(0, "locationClass", "locationMethod", "locationMethodSignature");
        try {
            stack.push((BNode)testNode1);
        }
        catch (Exception exception) {
            Assert.fail();
        }
        ProducerConsumerCellInfo cellInfo = stack.getCell(0);
        ArrayList producers = cellInfo.getProducers();
        Assert.assertEquals((long)1L, (long)producers.size());
        Assert.assertEquals((Object)testNode1, producers.get(0));
    }

    @Test
    public void testAnnotationStack4() {
        BasicBNode testNode1 = new BasicBNode(0, "locationClass", "locationMethod", "locationMethodSignature");
        ProducerConsumerStack entryStack = new ProducerConsumerStack();
        try {
            entryStack.push((BNode)testNode1);
            entryStack.push((BNode)testNode1);
            entryStack.push((BNode)testNode1);
            ProducerConsumerStack exitStack = entryStack.copy();
            Assert.assertFalse((entryStack == exitStack ? 1 : 0) != 0);
            Assert.assertTrue((entryStack.size() == exitStack.size() ? 1 : 0) != 0);
            int i2 = 0;
            while (i2 < entryStack.size()) {
                ProducerConsumerCellInfo right;
                ProducerConsumerCellInfo left = entryStack.getCell(i2);
                Assert.assertFalse((left == (right = exitStack.getCell(i2)) ? 1 : 0) != 0);
                ArrayList leftProducers = left.getProducers();
                ArrayList rightProducers = right.getProducers();
                Assert.assertTrue((leftProducers.size() == rightProducers.size() ? 1 : 0) != 0);
                Assert.assertTrue((leftProducers.size() == 1 ? 1 : 0) != 0);
                Assert.assertTrue((leftProducers.get(0) == rightProducers.get(0) ? 1 : 0) != 0);
                ++i2;
            }
        }
        catch (Exception exception) {
            Assert.fail();
        }
    }

    @Test
    public void testAnnotationStack5() {
        BasicBNode testNode1 = new BasicBNode(0, "locationClass", "locationMethod", "locationMethodSignature");
        BasicBNode testNode2 = new BasicBNode(0, "locationClass", "locationMethod", "locationMethodSignature");
        ProducerConsumerStack entryStack1 = new ProducerConsumerStack();
        ProducerConsumerStack entryStack2 = new ProducerConsumerStack();
        try {
            entryStack1.push((BNode)testNode1);
            entryStack1.push((BNode)testNode2);
            entryStack2.push((BNode)testNode1);
            entryStack2.push((BNode)testNode2);
            entryStack1.merge(entryStack2);
        }
        catch (Exception exception) {
            Assert.fail();
        }
        int count = 0;
        int i2 = 0;
        while (i2 < entryStack1.size()) {
            ProducerConsumerCellInfo cell = entryStack1.getCell(i2);
            ArrayList producers = cell.getProducers();
            Assert.assertTrue((producers.size() == 1 ? 1 : 0) != 0);
            if (producers.get(0) == testNode1) {
                ++count;
            } else if (producers.get(0) == testNode2) {
                count += 2;
            }
            ++i2;
        }
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test
    public void testAnnotationStack6() {
        boolean contuinueAnalysis;
        BasicBNode testNode1 = new BasicBNode(0, "locationClass", "locationMethod", "locationMethodSignature");
        BasicBNode testNode2 = new BasicBNode(1, "locationClass", "locationMethod", "locationMethodSignature");
        ProducerConsumerStack entryStack1 = new ProducerConsumerStack();
        ProducerConsumerStack entryStack2 = new ProducerConsumerStack();
        try {
            entryStack1.push((BNode)testNode1);
            entryStack2.push((BNode)testNode2);
            contuinueAnalysis = entryStack1.merge(entryStack2);
            Assert.assertTrue((boolean)contuinueAnalysis);
        }
        catch (Exception exception) {
            Assert.fail();
        }
        entryStack1 = new ProducerConsumerStack();
        entryStack2 = new ProducerConsumerStack();
        try {
            entryStack1.push((BNode)testNode1);
            entryStack2.push((BNode)testNode1);
            contuinueAnalysis = entryStack1.merge(entryStack2);
            Assert.assertFalse((boolean)contuinueAnalysis);
        }
        catch (Exception exception) {
            Assert.fail();
        }
    }
}

