public class LandingGearHandlerLand extends AperiodicEventHandler
{

	private final LandMission mission;

	public LandingGearHandlerLand(PriorityParameters priority,
	AperiodicParameters release, StorageParameters storage,
	String name, LandMission mission)
	{
		super(priority, release, storage, null);

		this.mission = mission;
	}

	@Override
	public void handleAsyncEvent()
	{
		Console.println("Deploying Landing Gear");

		boolean landingGearIsDeployed = mission.isLandingGearDeployed();

		if (landingGearIsDeployed)
		{
			mission.stowLandingGear();
		} else
		{
			mission.deployLandingGear();
		}
	}
}
