public class ACModeChanger extends MissionSequencer<Mission>
{
	private MainMission controllingMission;

	private int modesLeft = 3;

	public ACModeChanger(PriorityParameters priority,
	StorageParameters storage, MainMission controllingMission)
	{
		super(priority, storage, null);
		this.controllingMission = controllingMission;
	}

	@Override
	protected Mission getNextMission()
	{

		if (modesLeft == 3)
		{
			modesLeft--;

			return new TakeOffMission(controllingMission);
		} else if (modesLeft == 2)
		{
			modesLeft--;
			return new CruiseMission(controllingMission);
		} else if (modesLeft == 1)
		{
			modesLeft--;
			return new LandMission(controllingMission);
		} else
		{
			return null;
		}
	}
}
