public class TakeOffMonitor extends PeriodicEventHandler
{

	private final MainMission mainMission ;
	private final TakeOffMission takeoffMission;

	private double takeOffAltitude;
	private AperiodicEventHandler landingGearHandler;

	public TakeOffMonitor(PriorityParameters priority,
	PeriodicParameters periodic, StorageParameters storage,
	MainMission mainMission, TakeOffMission takeOffMission, double takeOffAltitude,
	AperiodicEventHandler landingGearHandler)
	{
		super(priority, periodic, storage, null);
		this.mainMission = mainMission;
		this.takeoffMission = takeOffMission;
		this.takeOffAltitude = takeOffAltitude;
		this.landingGearHandler = landingGearHandler;

	}

	@Override
	public void handleAsyncEvent()
	{
		Console.println("Reading Altitude");

		double altitude = mainMission.getAltitude();

		if (altitude > takeOffAltitude)
		{
			System.out.println("Take Off Complete");
			landingGearHandler.release();
			takeoffMission.requestTermination();
		}

	}
}
