public class TakeOffFailureHandler extends AperiodicEventHandler
{

	private final MainMission mainMission;
	private final TakeOffMission takeoffMission;

	private double threshold;

	public TakeOffFailureHandler(PriorityParameters priority,
	AperiodicParameters release, StorageParameters storage,
	String name, MainMission mainMission, TakeOffMission takeoffMission, Double threshold)
	{
		super(priority, release, storage, null);
		this.takeoffMission = takeoffMission;
		this.mainMission = mainMission;
		this.threshold = threshold;
	}

	@Override
	public void handleAsyncEvent()
	{

		double currentSpeed = mainMission.getAirSpeed();

		// in both cases this failure should be flagged somewhere
		if (currentSpeed < threshold)
		{
			System.out.println("Failure: Aborting");
			takeoffMission.takeOffAbort();
			takeoffMission.requestTermination();
		} else
		{
			Console.println("Failure: Continue and Land");
		}
	}
}
