public class SafeLandingHandler extends AperiodicEventHandler
{

	private final MainMission mainMission;

	private double threshold;

	public SafeLandingHandler(PriorityParameters priority,
	AperiodicParameters release, StorageParameters storage,
	String name, MainMission mainMission, Double threshold)
	{
		super(priority, release, storage, null);
		this.mainMission = mainMission;
		this.threshold = threshold;
	}

	@Override
	public void handleAsyncEvent()
	{

		double altitude = mainMission.getAltitude();

		// in both cases this failure should be flagged somewhere
		if (altitude < threshold)
		{
			Console.println("Failure: Pull Up");
			// Also perform some recovery action here, maybe a new mode
		} else
		{
			Console.println("Failure: Continue With Landing");
		}
	}
}
