public class LandingGearHandlerTakeOff extends AperiodicEventHandler
{

	private final TakeOffMission mission;

	public LandingGearHandlerTakeOff(PriorityParameters priority,
	AperiodicParameters release, StorageParameters storage,
	String name, TakeOffMission mission)
	{
		super(priority, release, storage, null);

		this.mission = mission;
	}

	@Override
	public void handleAsyncEvent()
	{
		System.out.println("Deploying Landing Gear");

		boolean landingGearIsDeployed = mission.isLandingGearDeployed();

		if (landingGearIsDeployed)
		{
			mission.stowLandingGear();
		} else
		{
			mission.deployLandingGear();
		}
	}
}
