public class LandingGearHandler extends AperiodicEventHandler
{

	private final LandingGearUser mission;


	public LandingGearHandler(PriorityParameters priority,
	AperiodicParameters release, StorageParameters storage,
	String name, LandingGearUser mission)
	{
		super(priority, release, storage, null);

		this.mission = mission;
	}

	@Override
	public void handleAsyncEvent()
	{
		Console.println("Deploying Landing Gear");

		boolean landingGearIsDeployed = mission.isLandingGearDeployed();

		if (landingGearIsDeployed)
		{
			mission.stowLandingGear();
		} else
		{
			mission.deployLandingGear();
		}
	}
}
