public class LandMission extends Mission implements LandingGearUser
{
	private final MainMission controllingMission;

	final double SAFE_LANDING_ALTITUDE = 10.00;

	private boolean abort = false;

	public LandMission(MainMission controllingMission)
	{
		this.controllingMission = controllingMission;
	}

	private boolean landingGearDeployed;

	@Override
	protected void initialize()
	{

		StorageParameters storageParametersSchedulable = new StorageParameters(
		Const.PRIVATE_MEM_DEFAULT - 30 * 1000,
		Const.PRIVATE_MEM_DEFAULT - 30 * 1000,
		Const.IMMORTAL_MEM_DEFAULT - 50 * 1000,
		Const.MISSION_MEM_DEFAULT - 100 * 1000);

		GroundDistanceMonitor groundDistanceMonitor = new GroundDistanceMonitor(
		new PriorityParameters(5), new PeriodicParameters(
		new RelativeTime(0, 0), new RelativeTime(10, 0)),
		storageParametersSchedulable, controllingMission);
		groundDistanceMonitor.register();

		LandingGearHandlerLand landingHandler = new LandingGearHandlerLand(
		new PriorityParameters(5), new AperiodicParameters(),
		storageParametersSchedulable, "Landing Handler", this);

		landingHandler.register();

		InstrumentLandingSystemMonitor ilsMonitor = new InstrumentLandingSystemMonitor(
		new PriorityParameters(5), new PeriodicParameters(
		new RelativeTime(0, 0), new RelativeTime(10, 0)),
		storageParametersSchedulable, "ILS Monitor", this);
		ilsMonitor.register();

		SafeLandingHandler safeLandingHandler = new SafeLandingHandler(
		new PriorityParameters(5), new AperiodicParameters(),
		storageParametersSchedulable, "Safe Landing Handler", controllingMission,
		SAFE_LANDING_ALTITUDE);

		safeLandingHandler.register();
	}

	@Override
	public long missionMemorySize()
	{
		return Const.MISSION_MEM_DEFAULT;
	}

	@Override
	public synchronized void deployLandingGear()
	{
		landingGearDeployed = true;
	}

	@Override
	public void stowLandingGear()
	{
		landingGearDeployed = false;
	}

	@Override
	public boolean isLandingGearDeployed()
	{
		return landingGearDeployed;
	}

	@Override
	public boolean cleanUp()
	{
		Console.println("Land Mission Cleanup");
		return false;
	}
}
