public class GroundDistanceMonitor extends PeriodicEventHandler
{

	private final MainMission mainMission;

	private final double readingOnGround;

	public GroundDistanceMonitor(PriorityParameters priority,
	PeriodicParameters periodic, StorageParameters storage,
	MainMission mainMission)
	{
		super(priority, periodic, storage, null);

		this.mainMission = mainMission;
		this.readingOnGround = mainMission.ALTITUDE_READING_ON_GROUND;
	}

	@Override
	public void handleAsyncEvent()
	{
		System.out.println("Checking Ground Distance");
		// read this value from sensors
		double distance = mainMission.getAltitude();

		if (distance == readingOnGround)
		{
			Console.println("Aircraft Landed, Terminating Mission");
			mainMission.requestTermination();
		}
	}

}
