with Ada.Real_Time.Timing_Events;
use  Ada.Real_Time.Timing_Events;
with System; use System;
package Timers is
  type Sensor is (Atrium, Ventricle);
  protected Timer is
    pragma Priority(Priority'First + 30);
    procedure Atrium_Pace_On(E : in out Timing_Event);
    procedure Atrium_Pace_Off(E : in out Timing_Event);
    procedure Ventricle_Pace_On(E : in out Timing_Event);
    procedure Ventricle_Pace_Off(E : in out Timing_Event);
    procedure PVARP_Countdown(E : in out Timing_Event);
    procedure Sensor_Read(E : in out Timing_Event);
  private
    Reading : Sensor := Atrium;
    IntrinsicV_Sensed : Boolean := False;
  end Timer;



  General_Timeouts : Timing_Event;
  Sensor_Readings : Timing_Event;

end Timers;
