package electing;

import javax.realtime.PeriodicParameters;
import javax.realtime.PriorityParameters;
import javax.safetycritical.PeriodicEventHandler;
import javax.safetycritical.StorageParameters;

import electionProtocol.ElectionProtocol;
import electionProtocol.ElectionProtocol.Claim;

public class Elector extends PeriodicEventHandler {
	ElectionProtocol electionProtocol;
	ElectingMission mission;

	public Elector(PriorityParameters priority, PeriodicParameters release, StorageParameters storage,
			ElectingMission mission, ElectionProtocol electionProtocol) {
		super(priority, release, storage);

		this.electionProtocol = electionProtocol;
		this.mission = mission;
	}

	@Override
	public void handleAsyncEvent() {
		electionProtocol.electLeader();
		if (electionProtocol.getState() != Claim.UNDECIDED) {
			mission.getRobotSequencer().isElecting = false;
			mission.requestTermination();
		}

	}

}
