package scjev3Infrastructure;

import javax.realtime.PriorityParameters;
import javax.safetycritical.MissionSequencer;
import javax.safetycritical.StorageParameters;

import com.UDPCommunication;

import dancing.DancingMission;
import electing.ElectingMission;
import electionProtocol.ElectionProtocol;
import scjev3App.SCJEV3App;

public class RobotMissionSeuqencer extends MissionSequencer<RobotMission> {

	private RobotMission dancer;
	private RobotMission elector;
	public boolean isElecting = true;

	public RobotMissionSeuqencer(PriorityParameters priority, StorageParameters storage,
			ElectionProtocol electionProtocol, StorageParameters storageParameters_Handlers) {
		super(priority, storage);

		dancer = new DancingMission(this, electionProtocol, storageParameters_Handlers);
		elector = new ElectingMission(this, electionProtocol, storageParameters_Handlers);
	}

	@Override
	protected RobotMission getNextMission() {
		if(SCJEV3App.isButtonBackPressed){
			UDPCommunication.closeBroadcastSender();
			UDPCommunication.closeReceiver();
			return null;
		}
			
		
		if (isElecting)
			return elector;
		else 
			return dancer;
	}

}
