package scjev3Infrastructure;

import javax.realtime.Clock;
import javax.realtime.PeriodicParameters;
import javax.realtime.PriorityParameters;
import javax.realtime.RelativeTime;
import javax.safetycritical.Mission;
import javax.safetycritical.StorageParameters;
import javax.scj.util.Const;

import electionProtocol.ElectionProtocol;
import scjev3App.SCJEV3App;

public class RobotMission extends Mission {

	private RobotMissionSeuqencer robotSeq;
	protected ElectionProtocol electionProtocol;
	protected StorageParameters storageParameters_Handlers;

	public RobotMission(RobotMissionSeuqencer robotSeq, ElectionProtocol electionProtocol,
			StorageParameters storageParameters_Handlers) {
		this.robotSeq = robotSeq;
		this.electionProtocol = electionProtocol;
		this.storageParameters_Handlers = storageParameters_Handlers;
	}

	@Override
	protected void initialize() {
		Receiver receiver = new Receiver(new PriorityParameters(SCJEV3App.RECEIVER_PRIORITY),
				new PeriodicParameters(new RelativeTime(Clock.getRealtimeClock()),
						new RelativeTime(SCJEV3App.RECEIVER_PERIOD, 0, Clock.getRealtimeClock())),
				storageParameters_Handlers, this, electionProtocol);
		receiver.register();

		Sender sender = new Sender(new PriorityParameters(SCJEV3App.SENDER_PRIORITY),
				new PeriodicParameters(new RelativeTime(Clock.getRealtimeClock()),
						new RelativeTime(SCJEV3App.SENDER_PERIOD, 0, Clock.getRealtimeClock())),
				storageParameters_Handlers, this, electionProtocol);
		sender.register();
	}

	@Override
	public long missionMemorySize() {
		return Const.MISSION_MEM;
	}

	public RobotMissionSeuqencer getRobotSequencer() {
		return robotSeq;
	}
}
