package scjev3App;

import javax.realtime.PriorityParameters;
import javax.safetycritical.LaunchLevel1;
import javax.safetycritical.MissionSequencer;
import javax.safetycritical.Safelet;
import javax.safetycritical.StorageParameters;
import javax.scj.util.Const;
import javax.scj.util.Priorities;

import com.UDPCommunication;

import devices.ev3.Button;
import electionProtocol.ElectionProtocol;
import scjev3Infrastructure.RobotMission;
import scjev3Infrastructure.RobotMissionSeuqencer;

public class SCJEV3App implements Safelet<RobotMission> {
	
	public static String[] ROBOTS_IP = { "10.42.0.1", "10.42.0.22", /*"10.42.0.55",*/ "10.42.0.84" };
	public static String NETWORK_NAME = "wlan1";
	public static String BROADCAST_ADDRESS = "10.42.0.255";
	
	public static int SENDER_PERIOD = 500;
	public static int RECEIVER_PERIOD = 500;
	public static int ELECTOR_PERIOD = 3000;
	public static int DETECTOR_PERIOD = 3000;
	public static int LEADERDANCER_PERIOD = 5000;
	
	public static int SENDER_PRIORITY = 8;
	public static int RECEIVER_PRIORITY = 10;
	public static int ELECTOR_PRIORITY = 6;
	public static int DETECTOR_PRIORITY = 6;
	public static int LEADERDANCER_PRIORITY = 6;
	
	public static Button back_button;
	public static boolean isButtonBackPressed = false;
	
	private StorageParameters storageParameters_Sequencer;
	private StorageParameters storageParameters_Handlers;
	private ElectionProtocol electionProtocol;

	@Override
	public MissionSequencer<RobotMission> getSequencer() {
		return new RobotMissionSeuqencer(new PriorityParameters(Priorities.SEQUENCER_PRIORITY),
				storageParameters_Sequencer, electionProtocol, storageParameters_Handlers);
	}

	@Override
	public long immortalMemorySize() {
		return Const.IMMORTAL_MEM;
	}

	@Override
	public void initializeApplication() {
		storageParameters_Sequencer = new StorageParameters(Const.OUTERMOST_SEQ_BACKING_STORE,
				new long[] { Const.HANDLER_STACK_SIZE }, Const.PRIVATE_MEM, Const.IMMORTAL_MEM, Const.MISSION_MEM);

		storageParameters_Handlers = new StorageParameters(Const.PRIVATE_BACKING_STORE + 4000,
				new long[] { Const.HANDLER_STACK_SIZE }, 4000, 0, 0);

		int[] ids = new int[ROBOTS_IP.length];
		for (int i = 0; i < ROBOTS_IP.length; i++) {
			ids[i] = ElectionProtocol.generateID(ROBOTS_IP[i]);
		}

		electionProtocol = new ElectionProtocol(NETWORK_NAME, ids);
		
		UDPCommunication.createSender(SCJEV3App.BROADCAST_ADDRESS);
		UDPCommunication.createReceiver();
		
		back_button = new Button(Button.ButtonID.BACK);
	}

	public static void main(String[] args) {
		devices.Console.println("program lanched");
		new LaunchLevel1(new SCJEV3App());
		devices.Console.println("program finished");
	}

}
