package electing;

import javax.realtime.Clock;
import javax.realtime.PeriodicParameters;
import javax.realtime.PriorityParameters;
import javax.realtime.RelativeTime;
import javax.safetycritical.StorageParameters;

import electionProtocol.ElectionProtocol;
import scjev3App.SCJEV3App;
import scjev3Infrastructure.RobotMission;
import scjev3Infrastructure.RobotMissionSeuqencer;

public class ElectingMission extends RobotMission{

	public ElectingMission(RobotMissionSeuqencer robotSeq, ElectionProtocol electionProtocol, StorageParameters storageParameters_Handlers) {
		super(robotSeq, electionProtocol, storageParameters_Handlers);
	}

	@Override
	protected void initialize() {
		super.initialize();
		
		Elector elector = new Elector(new PriorityParameters(SCJEV3App.ELECTOR_PRIORITY),
				new PeriodicParameters(new RelativeTime(Clock.getRealtimeClock()),
						new RelativeTime(SCJEV3App.ELECTOR_PERIOD, 0, Clock.getRealtimeClock())),
				storageParameters_Handlers, this, electionProtocol);
		elector.register();
	}
}
