package dancing;

import javax.realtime.Clock;
import javax.realtime.PeriodicParameters;
import javax.realtime.PriorityParameters;
import javax.realtime.RelativeTime;
import javax.safetycritical.StorageParameters;

import electionProtocol.ElectionProtocol;
import scjev3App.SCJEV3App;
import scjev3Infrastructure.RobotMission;
import scjev3Infrastructure.RobotMissionSeuqencer;

public class DancingMission extends RobotMission{
	
	public DancingMission(RobotMissionSeuqencer robotSeq, ElectionProtocol electionProtocol, StorageParameters storageParameters_Handlers) {
		super(robotSeq, electionProtocol, storageParameters_Handlers);
	}

	@Override
	protected void initialize() {
		super.initialize();
		
		LeaderDancer leaderDancer = new LeaderDancer(new PriorityParameters(SCJEV3App.LEADERDANCER_PRIORITY),
				new PeriodicParameters(new RelativeTime(Clock.getRealtimeClock()),
						new RelativeTime(SCJEV3App.LEADERDANCER_PERIOD, 0, Clock.getRealtimeClock())),
				storageParameters_Handlers, this, electionProtocol);
		leaderDancer.register();
		
		Detector detector = new Detector(new PriorityParameters(SCJEV3App.DETECTOR_PRIORITY),
				new PeriodicParameters(new RelativeTime(Clock.getRealtimeClock()),
						new RelativeTime(SCJEV3App.DETECTOR_PERIOD, 0, Clock.getRealtimeClock())),
				storageParameters_Handlers, this, electionProtocol);
		detector.register();
	}
}
