package scjev3Infrastructure;

import javax.realtime.PeriodicParameters;
import javax.realtime.PriorityParameters;
import javax.safetycritical.PeriodicEventHandler;
import javax.safetycritical.StorageParameters;

import com.UDPCommunication;

import electionProtocol.ElectionProtocol;
import icecaptools.IcecapCompileMe;
import scjev3App.SCJEV3App;

public class Sender extends PeriodicEventHandler{
	ElectionProtocol electionProtocol;
	RobotMission mission;
	
	public Sender(PriorityParameters priority, PeriodicParameters release, StorageParameters storage, RobotMission mission, ElectionProtocol electionProtocol) {
		super(priority, release, storage);
		this.electionProtocol = electionProtocol;
		this.mission = mission;
	}

	@Override
	@IcecapCompileMe
	public void handleAsyncEvent() {
		if (SCJEV3App.back_button.isPressed()) {
			SCJEV3App.isButtonBackPressed = true;
			mission.requestTermination();
		}
		
		UDPCommunication.sendBroadcastMsg(electionProtocol.StateToNeighbors());
	}

}
