package scjev3Infrastructure;

import javax.realtime.PeriodicParameters;
import javax.realtime.PriorityParameters;
import javax.safetycritical.PeriodicEventHandler;
import javax.safetycritical.StorageParameters;

import com.UDPCommunication;

import devices.ev3.EV3;
import devices.ev3.Motor;
import devices.ev3.MotorPort;
import devices.ev3.Motor.Direction;
import devices.ev3.MotorPort.MotorPortID;
import electionProtocol.ElectionProtocol;
import electionProtocol.ElectionProtocol.Command;

public class Receiver extends PeriodicEventHandler {

	ElectionProtocol electionProtocol;
	RobotMission mission;

	char command = 0;
	int speed = -1;
	int left_side_motor_num = -1;
	int duration = -1;
	int[] commandInfo;
	Motor[] motors;

	public Receiver(PriorityParameters priority, PeriodicParameters release, StorageParameters storage,
			RobotMission mission, ElectionProtocol electionProtocol) {
		super(priority, release, storage);
		this.electionProtocol = electionProtocol;
		this.mission = mission;
		
		MotorPort port = new MotorPort(MotorPortID.B);
		Motor motor_1 = new Motor(port);

		MotorPort port1 = new MotorPort(MotorPortID.C);
		Motor motor_2 = new Motor(port1);
		motors[0] = motor_1;
		motors[1] = motor_2;
	}

	@Override
	public void handleAsyncEvent() {
		do {
			String[] msg = UDPCommunication.receiveMsg();
	
			if (msg != null) {
	
				if (msg[1].charAt(0) == '0' || msg[1].charAt(0) == '1' || msg[1].charAt(0) == '2') {
					electionProtocol.collect(msg[1]);
				} else {
					if (electionProtocol.getState() == ElectionProtocol.Claim.FOLLOWER && msg[1] != null)
						devices.Console.println("leader told us: " + msg[1]);
						getCommand(msg[1]);
						action();
				}
	
			}
		} while(msg != null) 
	}
	
	private void getCommand(String msg){
		command = msg.charAt(0);

		if (command == Command.START || command == Command.STOP) {
			duration = getCommandInfo(msg.substring(2), 1)[0];

		} else if (command == Command.FORWARD || command == Command.BACKFORD || command == Command.CHANGESPEED) {
			int[] generated = getCommandInfo(msg.substring(2), 2);
			speed = generated[0];
			duration = generated[1];
		} else {
			int[] generated = getCommandInfo(msg.substring(2), 3);
			speed = generated[0];
			left_side_motor_num = generated[1];
			duration = generated[2];
		}

		if ((command == Command.TURNLEFT || command == Command.TURNRIGHT) && left_side_motor_num == -1) {
			devices.Console.println("wrong command, do not specify the number of left side motors");
			return;
		}

		if ((command == Command.FORWARD || command == Command.BACKFORD || command == Command.CHANGESPEED)
				&& speed == -1) {
			devices.Console.println("wrong command, do not specify the number of left side motors");
			return;
		}
	}

	private int[] getCommandInfo(String info, int count) {
		String speed = "", letfMotor = "", duration = "";
		int i = 0;

		switch (count) {
		case 1:
			for (; i < info.length(); i++) {
				duration = duration + info.charAt(i) + "";
			}
			commandInfo[0] = convert(duration);
			break;

		case 2:
			for (; i < info.length(); i++) {
				if (info.charAt(i) == '|')
					break;
				speed = speed + info.charAt(i) + "";
			}

			i++;
			for (; i < info.length(); i++) {
				duration = duration + info.charAt(i) + "";
			}

			commandInfo[0] = convert(speed);
			commandInfo[1] = convert(duration);
			break;

		case 3:
			for (; i < info.length(); i++) {
				if (info.charAt(i) == '|')
					break;
				speed = speed + info.charAt(i) + "";
			}

			i++;
			for (; i < info.length(); i++) {
				if (info.charAt(i) == '|')
					break;
				letfMotor = letfMotor + info.charAt(i) + "";
			}

			i++;
			for (; i < info.length(); i++) {
				duration = duration + info.charAt(i) + "";
			}

			commandInfo[0] = convert(speed);
			commandInfo[1] = convert(letfMotor);
			commandInfo[2] = convert(duration);
			break;
		}

		return commandInfo;
	}
	
	private int convert(String s) {
		if (s == null || s.length() == 0) {
			return -1;
		}

		int ret = 0;

		for (int i = 0; i < s.length(); i++) {
			char c = s.charAt(i);

			if (i == 0 && (c == '-')) {
				return -1;
			}

			if (c - '0' < 0 || c - '0' > 10) {
				devices.Console.println("wrong command: should be int here: " +s);
				throw new IllegalArgumentException();
			}

			int tmp = c - '0';

			ret *= 10;
			ret += tmp;

		}

		return ret;
	}
	
	private void action() {

		switch (command) {
		case Command.FORWARD:
			for (int i = 0; i < motors.length; i++) {
				motors[i].setPower((byte) speed);
				motors[i].setDirection(Direction.FORWARD);
				motors[i].start();
			}
			break;

		case Command.BACKFORD:
			for (int i = 0; i < motors.length; i++) {
				motors[i].setPower((byte) speed);
				motors[i].setDirection(Direction.BACKWARD);
				motors[i].start();
			}
			break;

		case Command.START:
			for (int i = 0; i < motors.length; i++) {
				motors[i].start();
			}
			break;

		case Command.STOP:
			for (int i = 0; i < motors.length; i++) {
				motors[i].stop();
			}
			break;

		case Command.CHANGESPEED:
			for (int i = 0; i < motors.length; i++) {
				motors[i].setPower((byte) speed);
			}
			break;

		case Command.TURNLEFT:
			for (int i = 0; i < motors.length; i++) {
				motors[i].setPower((byte) speed);

				if (i < left_side_motor_num) {
					motors[i].setDirection(Direction.FORWARD);
				} else {
					motors[i].setDirection(Direction.BACKWARD);
				}

				motors[i].start();
			}
			break;

		case Command.TURNRIGHT:
			for (int i = 0; i < motors.length; i++) {
				motors[i].setPower((byte) speed);

				if (i < left_side_motor_num) {
					motors[i].setDirection(Direction.BACKWARD);
				} else {
					motors[i].setDirection(Direction.FORWARD);
				}

				motors[i].start();
			}
			break;

		default:
			devices.Console.println("undefined command!: " + command);
			break;
		}

		if (duration > 0) {
			EV3.sleep(duration * 1000);
			for (int i = 0; i < motors.length; i++) {
				motors[i].stop();
			}
		}
	}
}