package dancing;

import javax.realtime.PeriodicParameters;
import javax.realtime.PriorityParameters;
import javax.safetycritical.ManagedMemory;
import javax.safetycritical.PeriodicEventHandler;
import javax.safetycritical.StorageParameters;

import com.UDPCommunication;

import devices.ev3.EV3;
import devices.ev3.Motor;
import devices.ev3.Motor.Direction;
import devices.ev3.MotorPort;
import devices.ev3.MotorPort.MotorPortID;
import electionProtocol.ElectionProtocol;

public class LeaderDancer extends PeriodicEventHandler {
	ElectionProtocol electionProtocol;
	DancingMission mission;

	Motor[] motors = new Motor[2];
	int commandCount = 1;
	boolean clockwise = false;

	public LeaderDancer(PriorityParameters priority, PeriodicParameters release, StorageParameters storage,
			DancingMission mission, ElectionProtocol electionProtocol) {
		super(priority, release, storage);

		this.electionProtocol = electionProtocol;
		this.mission = mission;
	}

	@Override
	public void handleAsyncEvent() {
		if (electionProtocol.getState() == ElectionProtocol.Claim.LEADER) {
			communicationBasedLeaderActor(6);
		}
	}

	private void communicationBasedLeaderActor(int commandsCount) {
		MotorPort port = new MotorPort(MotorPortID.B);
		Motor motor_1 = new Motor(port);

		MotorPort port1 = new MotorPort(MotorPortID.C);
		Motor motor_2 = new Motor(port1);
		motors[0] = motor_1;
		motors[1] = motor_2;

		commandRoutine(commandCount);

		if (!clockwise)
			commandCount++;
		else
			commandCount--;

		if (commandCount == commandsCount) {
			clockwise = true;
			commandCount--;
		}

		if (commandCount == 0) {
			clockwise = false;
			commandCount++;
		}
	}
	
	private void commandRoutine(int count) {
		switch (count) {
		case 1:
			devices.Console.println("forward");

			ManagedMemory.executeInOuterArea(new Runnable() {

				@Override
				public void run() {
					for (int i = 0; i < motors.length; i++) {
						motors[i].setPower((byte) 50);
						motors[i].setDirection(Direction.FORWARD);
						motors[i].start();
					}

					EV3.sleep(1000);
					for (int i = 0; i < motors.length; i++) {
						motors[i].stop();
					}
				}
			});

			UDPCommunication.sendBroadcastMsg(generateCommand('F', 50, 1));

			break;
		case 2:
			devices.Console.println("backward");

			ManagedMemory.executeInOuterArea(new Runnable() {

				@Override
				public void run() {
					for (int i = 0; i < motors.length; i++) {
						motors[i].setPower((byte) 50);
						motors[i].setDirection(Direction.BACKWARD);
						motors[i].start();
					}

					EV3.sleep(1000);
					for (int i = 0; i < motors.length; i++) {
						motors[i].stop();
					}
				}
			});

			UDPCommunication.sendBroadcastMsg(generateCommand('B', 50, 1));

			break;
		case 3:
			devices.Console.println("forward");

			ManagedMemory.executeInOuterArea(new Runnable() {

				@Override
				public void run() {
					for (int i = 0; i < motors.length; i++) {
						motors[i].setPower((byte) 50);
						motors[i].setDirection(Direction.FORWARD);
						motors[i].start();
					}

					EV3.sleep(1000);
					for (int i = 0; i < motors.length; i++) {
						motors[i].stop();
					}
				}
			});

			UDPCommunication.sendBroadcastMsg(generateCommand('F', 50, 1));

			break;
		case 4:
			devices.Console.println("turn left");

			ManagedMemory.executeInOuterArea(new Runnable() {

				@Override
				public void run() {

					motors[0].setPower((byte) 50);
					motors[0].setDirection(Direction.FORWARD);

					motors[1].setPower((byte) 50);
					motors[1].setDirection(Direction.BACKWARD);

					motors[0].start();
					motors[1].start();

					EV3.sleep(1000);

					for (int i = 0; i < motors.length; i++) {
						motors[i].stop();
					}
				}
			});

			UDPCommunication.sendBroadcastMsg(generateCommand('L', 50, 1, 1));
			break;
		case 5:
			devices.Console.println("turn right");

			ManagedMemory.executeInOuterArea(new Runnable() {

				@Override
				public void run() {

					motors[0].setPower((byte) 50);
					motors[0].setDirection(Direction.BACKWARD);

					motors[1].setPower((byte) 50);
					motors[1].setDirection(Direction.FORWARD);

					motors[0].start();
					motors[1].start();

					EV3.sleep(1000);

					for (int i = 0; i < motors.length; i++) {
						motors[i].stop();
					}
				}
			});

			UDPCommunication.sendBroadcastMsg(generateCommand('R', 50, 1, 1));
			break;
		case 6:
			devices.Console.println("forward");

			ManagedMemory.executeInOuterArea(new Runnable() {

				@Override
				public void run() {
					for (int i = 0; i < motors.length; i++) {
						motors[i].setPower((byte) 50);
						motors[i].setDirection(Direction.FORWARD);
						motors[i].start();
					}

					EV3.sleep(2000);
					for (int i = 0; i < motors.length; i++) {
						motors[i].stop();
					}
				}
			});

			UDPCommunication.sendBroadcastMsg(generateCommand('F', 50, 2));
			break;
		default:
			;
		}

	}

	private String generateCommand(char command, int speed, int duration) {
		String com = command + "|" + speed + "|" + duration;
		return com;
	}
	
	private String generateCommand(char command, int speed, int numOfLeftMotors, int duration) {
		String com = command + "|" + speed + "|" + numOfLeftMotors + "|" + duration;
		return com;
	}


}
