package dancing;

import javax.realtime.PeriodicParameters;
import javax.realtime.PriorityParameters;
import javax.safetycritical.PeriodicEventHandler;
import javax.safetycritical.StorageParameters;

import electionProtocol.ElectionProtocol;

public class Detector extends PeriodicEventHandler {
	ElectionProtocol electionProtocol;
	DancingMission mission;
	int count = 0;

	public Detector(PriorityParameters priority, PeriodicParameters release, StorageParameters storage,
			DancingMission mission, ElectionProtocol electionProtocol) {
		super(priority, release, storage);

		this.electionProtocol = electionProtocol;
		this.mission = mission;
	}

	@Override
	public void handleAsyncEvent() {
		if (count != 0) {
			electionProtocol.printMyNeighbors();

			if (electionProtocol.isLeadershipBroken()) {
				devices.Console.println("leadership broken");
				mission.getRobotSequencer().isElecting = true;
				mission.requestTermination();
			}
			else
				electionProtocol.increaseTime();
		}

		count++;

	}

}
