This folder contains files to accompany the thesis 'Ahead-of-Time
Algebraic Compilation for Safety-Critical Java'. It contains a total
of 9 folders:

* ``ClassFileModelConverter``, a prototype implementation of the
  compilation strategy from Safety-Critical Java (SCJ) bytecode to Circus
  specification language models and C code (see "Prototype usage"
  below);
* ``Barrier``, ``Buffer`` and ``PersistentSignal``, which contain the
  code of three SCJ example programs described in the thesis, written
  for the icecap HVM and with the corresponding C code generated by
  icecap found in the ``cout`` folder of each;
* ``ModelBarrier``, ``ModelBuffer`` and ``ModelPersistentSignal``,
  which contain versions of the three examples written to work with
  our prototype (without main methods and using our own standard
  library), with the result of passing them through the prototype
  given in a ``.c`` and ``.h`` file in the ``bin/main`` folder of
  each;
* ``ExampleSCJLibrary``, which contains an example self-contained SCJ
  library, designed to work with our prototype;
* ``Model``, which contains LaTeX-syntax Circus sources for our
  interpreting SCJ virtual machine model, as well as an example layout
  of the post-compilation struct manager model.

Dependencies
------------

The ``ClassFileModelConverter`` depends on the Apache Byte Code
Engineering Library
(<https://commons.apache.org/proper/commons-bcel/>) to read Java class
files.

The ``Barrier``, ``Buffer`` and ``PersistentSignal`` examples depend
on the icecap SDK, available here: <http://icelab.dk/download.html>.

The ``ModelBarrier``, ``ModelBuffer`` and ``ModelPersistentSignal``
examples depend only on ``ExampleSCJLibrary``.


Prototype usage
---------------

Programs written for use with the prototype should be written to only
depend on ``ExampleSCJLibrary`` (and not on the normal Java standard
library). The environment variable ``SCJPATH`` must be set with the
path to the ``ExampleSCJLibrary`` ``.class`` files. When using the
prototype, an output file must be provided using ``-o`` option. The
names of one or more input files may also be provided. If no input
files are provided then all the ``.class`` files in the current
working directory are used by default. By default the prototype
converts the input class files to the corresponding inputs to the
Circus SCJ virtual machine model. This behaviour may be changed by
using the following options:

* ``-l`` indicates that the SCJ libraries should be included in the
  set of files processed. The ``SCJPATH`` environment variable
  must be set when this option is used.

* ``--EPC`` indicates that the elimination of program counter stage of
  the compilation strategy should be executed, and the resulting
  Circus code output. This option implies ``-l``.
  
* ``--EFS`` indicates that the elimination of program counter and
  elimination of frame stack stages of the compilation strategy should
  be executed, and the resulting Circus code output. This option
  implies ``-l``.
  
* ``-p`` indicates a preamble should be output as part of Circus code
  files output by the prototype, so thet they can be typeset as
  standalone LaTeX files.
  
* ``-C`` indicates that the complete compilation strategy should be
  executed to produce C code. This option implies ``-l``. When this
  option is used, the output file must end with ``.c`` and a
  corresponding file ending in ``.h`` will also be generated
  containing declarations used in the ``.c`` file.
  
* ``--expand-iinc`` indicates ``iinc`` bytecode instructions should be
  expanded to a sequence of instructions to push values onto the stack
  and add them, for compatibility with earlier versions of the
  prototype that did not fully support ``iinc``.
  
