package main;

import javax.realtime.ConfigurationParameters;
import javax.realtime.MemoryArea;
import javax.realtime.PeriodicParameters;
import javax.realtime.PriorityParameters;
import javax.realtime.RelativeTime;
import javax.realtime.memory.ScopeParameters;
import javax.safetycritical.AperiodicEventHandler;
import javax.safetycritical.ManagedMemory;
import javax.safetycritical.PeriodicEventHandler;
import javax.safetycritical.PriorityScheduler;
import javax.scj.util.Const;


public class Producer extends PeriodicEventHandler {
	/*
	 * Event to trigger Consumer
	 */
	private AperiodicEventHandler consume;
	
	/*
	 * Keep a reference to the last object created
	 */
	private Object data;
	
	/*
	 * Limit the total number of objects to avoid running out of memory in MissionMemory
	 */
	private final int MAX_NUM_OF_OBJECTS = 5;
	private int NUM_OF_OBJECTS = 0;

	private Buffer buffer;

	private Runnable _switch = new Runnable() {
		public void run() {
			Producer.this.data = new Object();
		}		
	};

	
// (annotations turned off to work with Java 1.4)     @SCJAllowed(LEVEL_1)	
	public Producer(AperiodicEventHandler consumer, Buffer buffer) {
		/*
		 	  //priority
			  new PriorityParameters(PriorityScheduler.instance().getNormPriority()),
			  //period
			  new PeriodicParameters(null, new RelativeTime(3000, 0)),
			  //storage
			  new StorageParameters(32768, 4096, 4096),
			  //size
			  65523,
			  //name
			  "Producer"
		*/
		super(
				new PriorityParameters(PriorityScheduler.instance().getNormPriority()),
				new PeriodicParameters(new RelativeTime(), new RelativeTime(3000,0)),
				new ScopeParameters(
						Const.PRIVATE_BACKING_STORE,
						Const.PRIVATE_MEM,
						0, 0),
				new ConfigurationParameters(-1, -1, new LongArray1(Const.HANDLER_STACK_SIZE))
		      );
		
		this.buffer = buffer;
		this.consume = consumer;
	}
	
	@Override
	public void handleAsyncEvent() {
		// System.out.println("** Producer **");
		// System.out.println("2.1 ProducerPrivate : " + ((ManagedMemory) RealtimeThread.getCurrentMemoryArea()).toString());
		
		/*
		 * Limit the creation of new objects to avoid running out of Mission Memory
		 */
		if (NUM_OF_OBJECTS <= MAX_NUM_OF_OBJECTS) {
			/*
			 * Allocate new data object and update count
			 */
			//try {
			ManagedMemory.executeInOuterArea(this._switch);
			//} catch (IllegalArgumentException e1) {
			//	System.out.println("2.3 Exception while trying to allocate new object in MissionMemory");
			//	System.out.println("2.3 Aborting current release");
			//	return;
			//} catch (OutOfMemoryError e1) {
			//	System.out.println("2.3 Exception while trying to allocate new object in MissionMemory");
			//	System.out.println("2.3 Aborting current release");
			//	return;
			//} catch (ExceptionInInitializerError e1) {
			//	System.out.println("2.3 Exception while trying to allocate new object in MissionMemory");
			//	System.out.println("2.3 Aborting current release");
			//	return;
			//}
			
			NUM_OF_OBJECTS++;
			
			//System.out.println("2.3 New Object[" + NUM_OF_OBJECTS +"] is in : " + (MemoryArea.getMemoryArea(data).toString()));
			
			/*
			 * Store a reference to the new object in the buffer
			 */
			this.buffer.put(data);

			/*
			 * Trigger the Consumer handler
			 */
			this.consume.release();			
		}		
	}
}
