package javax.safetycritical;

import javax.realtime.ConfigurationParameters;
import javax.realtime.PeriodicParameters;
import javax.realtime.PriorityParameters;
import javax.realtime.memory.ScopeParameters;

public abstract class PeriodicEventHandler extends ManagedEventHandler {

	private int start;
	private int period; 
	
	public PeriodicEventHandler(PriorityParameters priority,
			PeriodicParameters release,
			ScopeParameters storage,
			ConfigurationParameters config) {
		super(priority, storage, config);
		
		this.start = (int) (release.getStart().getMilliseconds() + release.getStart().getNanoseconds());
		this.period = (int) (release.getPeriod().getMilliseconds() + release.getPeriod().getNanoseconds());
		
		initPEH(this,
				this.priority,
				this.start,
				this.period,
				this.backingStoreSpace,
				this.allocAreaSpace,
				this.stackSize);
	}
	
	
	private static native void initPEH(
			PeriodicEventHandler peh,
			int priority,
			int start,
			int period,
			int backingStoreSpace,
			int allocAreaSpace,
			int stackSize);
}
