package javax.safetycritical;

import javax.realtime.AperiodicParameters;
import javax.realtime.ConfigurationParameters;
import javax.realtime.PriorityParameters;
import javax.realtime.memory.ScopeParameters;

public abstract class AperiodicEventHandler extends ManagedEventHandler {
	
	public AperiodicEventHandler(PriorityParameters priority,
			AperiodicParameters release,
			ScopeParameters storage,
			ConfigurationParameters config) {
		super(priority, storage, config);
		initAPEH(this,
				this.priority,
				this.backingStoreSpace,
				this.allocAreaSpace,
				this.stackSize);
	}
	
	private static native void initAPEH(
			AperiodicEventHandler apeh,
			int priority,
			int backingStoreSpace,
			int allocAreaSpace,
			int stackSize);

	public final void release() {
		releaseAperiodic(this);
	}
	
	private static native void releaseAperiodic(AperiodicEventHandler apeh);
}
