package main;

import java.util.Objects;

import org.apache.commons.bcel6.classfile.Utility;

public class MethodID {
	private final String methodID;
	private final int numArgs;
	private final boolean isInit;
	private final boolean hasReturn;
	
	
	public MethodID(String methodName, String signature){
		if (methodName == null || signature == null) {
			throw new IllegalArgumentException("methodName and signature must be non-null");
		}
		this.isInit = methodName.equals("<init>");
		this.methodID = methodName.replace("<", "").replace(">", "").replace("$", "") + 
				signature.replace('[', 'A').replace(";", "\\_").replace("(", "\\_").replace(")", "\\_").replace("/", "\\_").replace("$", "");
		int tmpArgs = 0;
		for (String arg : Utility.methodSignatureArgumentTypes(signature)) {
			if (arg.equals("long") || arg.equals("double")) {
				tmpArgs += 2;
			} else {
				tmpArgs += 1;
			}
				
		}
		this.numArgs = tmpArgs;
		this.hasReturn = !Utility.methodSignatureReturnType(signature).equals("void");
		
	}
	
	public String toModelString() {
		return methodID;
	}
	
	public int getNumArguments() {
		return numArgs;
	}
	
	@Override
	public String toString() {
		return this.toModelString();
	}
	
	@Override
	public int hashCode(){
		return Objects.hash(methodID);
	}
	
	@Override
	public boolean equals(Object x) {
		if (x instanceof MethodID) {
			return (((MethodID) x).methodID.equals(this.methodID));
		}
		return false;
	}

	public boolean isInit() {
		return this.isInit;
	}
	
	public boolean hasReturnValue() {
		return hasReturn;
	}
}
