package main;

import java.util.Objects;


public class FieldID {
	private final String fieldID;
	private final boolean isLongOrDouble;
	
	
	public FieldID(String fieldName, String signature){
		if (fieldName == null || signature == null) {
			throw new IllegalArgumentException("fieldName and signature must be non-null");
		}
		this.fieldID = fieldName.replace("$", "") + signature.replace('[', 'A').replace(";", "\\_").replace("/", "\\_").replace("$", "");
		this.isLongOrDouble = signature.equals("J") || signature.equals("D"); 
	}
	
	public String toModelString() {
		return fieldID;
	}
	
	public boolean isLongOrDouble() {
		return isLongOrDouble;
	}
	
	@Override
	public String toString() {
		return this.toModelString();
	}
	
	@Override
	public int hashCode(){
		return Objects.hash(fieldID);
	}
	
	@Override
	public boolean equals(Object x) {
		if (x instanceof FieldID) {
			return (((FieldID) x).fieldID.equals(this.fieldID));
		}
		return false;
	}
}
