package main;

import javax.realtime.ConfigurationParameters;
import javax.realtime.PeriodicParameters;
import javax.realtime.PriorityParameters;
import javax.realtime.RelativeTime;
import javax.safetycritical.AperiodicEventHandler;
import javax.safetycritical.PeriodicEventHandler;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.StorageParameters;
import javax.scj.util.Const;

public class Button extends PeriodicEventHandler{

	private AperiodicEventHandler event;

	public Button(AperiodicEventHandler e, long period_ms, long offset_ms) {		
		super(
			  new PriorityParameters(PriorityScheduler.instance().getNormPriority()),
			  new PeriodicParameters(new RelativeTime(offset_ms, 0), new RelativeTime(period_ms, 0)),
			  new StorageParameters(
						Const.PRIVATE_BACKING_STORE,
						Const.PRIVATE_MEM,
						0, 0),
			  new ConfigurationParameters(-1, -1, new long[] {Const.HANDLER_STACK_SIZE}));
		this.event = e;
	}

	public void handleAsyncEvent()
	{
		this.event.release();
	}
}
