package main;

import javax.realtime.ConfigurationParameters;
import javax.realtime.PeriodicParameters;
import javax.realtime.PriorityParameters;
import javax.realtime.RelativeTime;
import javax.safetycritical.AperiodicEventHandler;
import javax.safetycritical.PeriodicEventHandler;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.StorageParameters;
import javax.scj.util.Const;


public class Producer extends PeriodicEventHandler {

	private PersistentSignal _signal;
	private AperiodicEventHandler _worker;

	public Producer(PersistentSignal signal, AperiodicEventHandler worker, long period_ms, long offset_ms) {
		super(
				new PriorityParameters(PriorityScheduler.instance().getNormPriority()),
				new PeriodicParameters(new RelativeTime(offset_ms, 0), new RelativeTime(period_ms, 0)),
				new StorageParameters(
						Const.PRIVATE_BACKING_STORE,
						Const.PRIVATE_MEM,
						0, 0),
				new ConfigurationParameters(-1, -1, new long[] {Const.HANDLER_STACK_SIZE}));
		this._signal = signal;
		this._worker = worker;
	}

	public void handleAsyncEvent() {
		//System.out.println("\n1.1 Producer - starting  computation ");
		devices.Console.println(-11);
		
		/* reset signal at each release */
		this._signal.reset();
		this._worker.release();
		
		/* do some computation */
		//System.out.println("1.2 Producer - starting  extra computation ");
		devices.Console.println(-12);
		for (int i = 0; i < 1000000; i++) {
			i = i + 1;
			i = i - 1;
		}
		//System.out.println("1.3 Producer - finishing computation ");
		devices.Console.println(-13);
		
		/* check if output is done */
		if (this._signal.isSet()) {
			//System.out.println("1.4 Producer - output done");
			devices.Console.println(-141);
		} else {
			//System.out.println("1.4 Producer - output not done yet");
			devices.Console.println(-140);
		}
		
	}

}
