package main;

import javax.safetycritical.AperiodicEventHandler;
import javax.safetycritical.Mission;


public class MainMission extends Mission {
	
	public long missionMemorySize() {
		return 1000000;
	}
	
	public void initialize() {
		//devices.Console.println("Initializing main mission");		 
		
		/*
		 * Create Launch AEH
		 * Pass a reference to the shared barrier
		 * ManagedHandlers need to register themselves upon creation
		 */
		AperiodicEventHandler launch = new LaunchHandler();
		launch.register();

		/* Create a barrier for 2 handlers, 
		 * Triggers launch event when ready to proceed
		 */
		Barrier barrier = new Barrier(2, launch);
		
		/* The fire1 and fire2 events release fire1Handler and fire2Handler. */
		AperiodicEventHandler fire1 = new FireHandler(barrier, 0); 	
		AperiodicEventHandler fire2 = new FireHandler(barrier, 1); 
		
		/*
		 * Create Fire1 and Fire2 AEH
		 * Pass a reference to the shared barrier
		 * ManagedHandlers need to register themselves upon creation
		 */
		fire1.register();
		fire2.register();
		
		/*
		 * Create PEHs that generate event occurrences.
		 */
		(new Button(fire1, 2000, 0)).register();	//2s
		(new Button(fire2, 9000, 9000)).register();	//9s + 9s offset
	}
}
