package main;

import javax.realtime.AperiodicParameters;
import javax.realtime.ConfigurationParameters;
import javax.realtime.PriorityParameters;
import javax.realtime.memory.ScopeParameters;
import javax.safetycritical.AperiodicEventHandler;
import javax.safetycritical.PriorityScheduler;
import javax.scj.util.Const;

public class FireHandler extends AperiodicEventHandler {

	/*
	 * Reference to MissionMemory
	 */
	private Barrier barrier;
	private int id;

	public FireHandler(Barrier barrier, int id) {
		
		super(
			  new PriorityParameters(PriorityScheduler.instance().getMaxPriority()),
			  new AperiodicParameters(),
			  new ScopeParameters(
						Const.PRIVATE_BACKING_STORE,
						Const.PRIVATE_MEM,
						0, 0),
			  new ConfigurationParameters(-1, -1, new LongArray1(Const.HANDLER_STACK_SIZE)));
		
		this.barrier = barrier;
		this.id = id;
	}

	public void handleAsyncEvent() {
			//devices.Console.println("\n** FireHandler is now handling event " + id + " **");
			devices.Console.write(id);
		
			/*
			 * If we have already triggered the barrier,
			 * do not retrigger
			 */
			if (barrier.isAlreadyTriggered(this.id)) return;
			
			barrier.trigger(this.id);
	}

}
