#include <stdlib.h>

#include <stdint.h>

void setPriorityCeiling(int32_t obj, int32_t ceiling);
void output(int32_t value);
int32_t input(void);
void registerSchedulable(int32_t obj);
void enterPrivateMemory(int32_t size);
void executeInAreaOf(int32_t obj);
void executeInOuterArea(void);
void exitMemory(void);
void initAPEH(int32_t apeh, int32_t priority, int32_t backingStoreSpace, int32_t allocAreaSpace, int32_t stackSize);
void initPEH(int32_t peh, int32_t priority, int32_t start, int32_t period, int32_t backingStoreSpace, int32_t allocAreaSpace, int32_t stackSize);
void initOSEHAbs(int32_t oseh, int32_t priority, int32_t startTime, int32_t backingStoreSpace, int32_t allocAreaSpace, int32_t stackSize);
void initOSEHRel(int32_t oseh, int32_t priority, int32_t startTime, int32_t backingStoreSpace, int32_t allocAreaSpace, int32_t stackSize);
void takeLock(int32_t obj);
void releaseLock(int32_t obj);
void releaseAperiodic(int32_t apeh);
int32_t newObject(int32_t classID);

const int32_t main_ButtonID = 0;
const int32_t javax_safetycritical_PeriodicEventHandlerID = 1;
const int32_t javax_realtime_PriorityParametersID = 2;
const int32_t javax_safetycritical_PrioritySchedulerID = 3;
const int32_t javax_realtime_PeriodicParametersID = 4;
const int32_t javax_realtime_RelativeTimeID = 5;
const int32_t javax_realtime_memory_ScopeParametersID = 6;
const int32_t javax_realtime_ConfigurationParametersID = 7;
const int32_t java_lang_LongArray1ID = 8;
const int32_t javax_safetycritical_AperiodicEventHandlerID = 9;
const int32_t main_FireHandlerID = 10;
const int32_t javax_realtime_AperiodicParametersID = 11;
const int32_t devices_ConsoleID = 12;
const int32_t main_BarrierID = 13;
const int32_t main_LaunchHandlerID = 14;
const int32_t main_MainMissionID = 15;
const int32_t javax_safetycritical_MissionID = 16;
const int32_t main_MySafeletID = 17;
const int32_t java_lang_ObjectID = 18;
const int32_t javax_safetycritical_SafeletID = 19;
const int32_t main_MainSequenceID = 20;
const int32_t javax_safetycritical_MissionSequencerID = 21;
const int32_t javax_safetycritical_ServicesID = 22;
const int32_t java_lang_BooleanArrayID = 23;
const int32_t javax_safetycritical_ManagedEventHandlerID = 24;
const int32_t javax_realtime_BoundAsyncEventHandlerID = 25;
const int32_t javax_safetycritical_ManagedSchedulableID = 26;
const int32_t java_lang_LongArrayID = 27;
const int32_t javax_safetycritical_ManagedMemoryID = 28;
const int32_t javax_realtime_memory_StackedMemoryID = 29;
const int32_t java_lang_RunnableID = 30;
const int32_t javax_safetycritical_OneShotEventHandlerID = 31;
const int32_t javax_realtime_AbsoluteTimeID = 32;
const int32_t javax_realtime_PrioritySchedulerID = 33;
const int32_t javax_safetycritical_io_ConsoleConnectionID = 34;
const int32_t javax_microedition_io_StreamConnectionID = 35;
const int32_t javax_safetycritical_io_ConsoleInputID = 36;
const int32_t javax_safetycritical_io_ConsoleOutputID = 37;
const int32_t java_io_DataInputStreamID = 38;
const int32_t java_io_DataOutputStreamID = 39;
const int32_t java_io_InputStreamID = 40;
const int32_t java_io_OutputStreamID = 41;
const int32_t javax_realtime_HighResolutionTimeID = 42;
const int32_t javax_realtime_ReleaseParametersID = 43;
const int32_t javax_realtime_AsyncBaseEventHandlerID = 44;
const int32_t javax_realtime_SchedulableID = 45;
const int32_t javax_realtime_AsyncEventHandlerID = 46;
const int32_t javax_realtime_BoundAsyncBaseEventHandlerID = 47;
const int32_t javax_realtime_BoundSchedulableID = 48;
const int32_t javax_realtime_BoundRealtimeExecutorID = 49;
const int32_t javax_realtime_ChronographID = 50;
const int32_t java_lang_CloneableID = 51;
const int32_t java_lang_ComparableID = 52;
const int32_t javax_realtime_MemoryAreaID = 53;
const int32_t javax_realtime_MemoryParametersID = 54;
const int32_t javax_realtime_SchedulingParametersID = 55;
const int32_t javax_realtime_SchedulerID = 56;
const int32_t javax_realtime_ReleasableID = 57;
const int32_t javax_realtime_TimableID = 58;
const int32_t javax_realtime_memory_ScopedMemoryID = 59;
const int32_t javax_microedition_io_ConnectionID = 60;
const int32_t javax_microedition_io_InputConnectionID = 61;
const int32_t javax_microedition_io_OutputConnectionID = 62;
const int32_t java_lang_ArrayID = 63;
const int32_t java_lang_Array1ID = 64;
const int32_t java_lang_Array2ID = 65;
const int32_t java_lang_Array3ID = 66;
const int32_t java_lang_Array4ID = 67;
const int32_t java_lang_Array5ID = 68;
const int32_t java_lang_BooleanArray1ID = 69;
const int32_t java_lang_BooleanArray2ID = 70;
const int32_t java_lang_BooleanArray3ID = 71;
const int32_t java_lang_BooleanArray4ID = 72;
const int32_t java_lang_BooleanArray5ID = 73;
const int32_t java_lang_IntArrayID = 74;
const int32_t java_lang_IntArray1ID = 75;
const int32_t java_lang_StringID = 76;
const int32_t java_io_CloseableID = 77;
const int32_t java_io_FlushableID = 78;
const int32_t javax_scj_util_ConstID = 79;

typedef struct main_Button {
	int32_t classID;
	int32_t priorityI;
	int32_t backingStoreSpaceI;
	int32_t allocAreaSpaceI;
	int32_t stackSizeI;
	int32_t startI;
	int32_t periodI;
	int32_t eventLjavax_safetycritical_AperiodicEventHandler_;
} main_Button;

typedef struct main_FireHandler {
	int32_t classID;
	int32_t priorityI;
	int32_t backingStoreSpaceI;
	int32_t allocAreaSpaceI;
	int32_t stackSizeI;
	int32_t barrierLmain_Barrier_;
	int32_t idI;
} main_FireHandler;

typedef struct main_LaunchHandler {
	int32_t classID;
	int32_t priorityI;
	int32_t backingStoreSpaceI;
	int32_t allocAreaSpaceI;
	int32_t stackSizeI;
} main_LaunchHandler;

typedef struct main_MainMission {
	int32_t classID;
} main_MainMission;

typedef struct main_MySafelet {
	int32_t classID;
} main_MySafelet;

typedef struct main_MainSequence {
	int32_t classID;
	int32_t priorityI;
	int32_t backingStoreSpaceI;
	int32_t allocAreaSpaceI;
	int32_t stackSizeI;
} main_MainSequence;

typedef struct main_Barrier {
	int32_t classID;
	int32_t flagLjava_lang_BooleanArray_;
	int32_t eLjavax_safetycritical_AperiodicEventHandler_;
} main_Barrier;

typedef struct javax_safetycritical_AperiodicEventHandler {
	int32_t classID;
	int32_t priorityI;
	int32_t backingStoreSpaceI;
	int32_t allocAreaSpaceI;
	int32_t stackSizeI;
} javax_safetycritical_AperiodicEventHandler;

typedef struct javax_safetycritical_ManagedEventHandler {
	int32_t classID;
	int32_t priorityI;
	int32_t backingStoreSpaceI;
	int32_t allocAreaSpaceI;
	int32_t stackSizeI;
} javax_safetycritical_ManagedEventHandler;

typedef struct javax_safetycritical_ManagedMemory {
	int32_t classID;
} javax_safetycritical_ManagedMemory;

typedef struct javax_safetycritical_ManagedSchedulable {
	int32_t classID;
} javax_safetycritical_ManagedSchedulable;

typedef struct javax_safetycritical_Mission {
	int32_t classID;
} javax_safetycritical_Mission;

typedef struct javax_safetycritical_MissionSequencer {
	int32_t classID;
	int32_t priorityI;
	int32_t backingStoreSpaceI;
	int32_t allocAreaSpaceI;
	int32_t stackSizeI;
} javax_safetycritical_MissionSequencer;

typedef struct javax_safetycritical_OneShotEventHandler {
	int32_t classID;
	int32_t priorityI;
	int32_t backingStoreSpaceI;
	int32_t allocAreaSpaceI;
	int32_t stackSizeI;
	int32_t startI;
} javax_safetycritical_OneShotEventHandler;

typedef struct javax_safetycritical_PeriodicEventHandler {
	int32_t classID;
	int32_t priorityI;
	int32_t backingStoreSpaceI;
	int32_t allocAreaSpaceI;
	int32_t stackSizeI;
	int32_t startI;
	int32_t periodI;
} javax_safetycritical_PeriodicEventHandler;

typedef struct javax_safetycritical_PriorityScheduler {
	int32_t classID;
} javax_safetycritical_PriorityScheduler;

typedef struct javax_safetycritical_Safelet {
	int32_t classID;
} javax_safetycritical_Safelet;

typedef struct javax_safetycritical_Services {
	int32_t classID;
} javax_safetycritical_Services;

typedef struct javax_safetycritical_io_ConsoleConnection {
	int32_t classID;
	int32_t nameLjava_lang_String_;
	int32_t inputStreamLjavax_safetycritical_io_ConsoleInput_;
	int32_t outputStreamLjavax_safetycritical_io_ConsoleOutput_;
	int32_t dataInputStreamLjava_io_DataInputStream_;
	int32_t dataOutputStreamLjava_io_DataOutputStream_;
} javax_safetycritical_io_ConsoleConnection;

typedef struct javax_safetycritical_io_ConsoleInput {
	int32_t classID;
} javax_safetycritical_io_ConsoleInput;

typedef struct javax_safetycritical_io_ConsoleOutput {
	int32_t classID;
} javax_safetycritical_io_ConsoleOutput;

typedef struct javax_realtime_AbsoluteTime {
	int32_t classID;
	int32_t millisJ_msb;
	int32_t millisJ_lsb;
	int32_t nanosI;
} javax_realtime_AbsoluteTime;

typedef struct javax_realtime_AperiodicParameters {
	int32_t classID;
	int32_t deadlineLjavax_realtime_RelativeTime_;
	int32_t missHandlerLjavax_realtime_AsyncEventHandler_;
} javax_realtime_AperiodicParameters;

typedef struct javax_realtime_AsyncBaseEventHandler {
	int32_t classID;
} javax_realtime_AsyncBaseEventHandler;

typedef struct javax_realtime_AsyncEventHandler {
	int32_t classID;
} javax_realtime_AsyncEventHandler;

typedef struct javax_realtime_BoundAsyncBaseEventHandler {
	int32_t classID;
} javax_realtime_BoundAsyncBaseEventHandler;

typedef struct javax_realtime_BoundAsyncEventHandler {
	int32_t classID;
} javax_realtime_BoundAsyncEventHandler;

typedef struct javax_realtime_BoundRealtimeExecutor {
	int32_t classID;
} javax_realtime_BoundRealtimeExecutor;

typedef struct javax_realtime_BoundSchedulable {
	int32_t classID;
} javax_realtime_BoundSchedulable;

typedef struct javax_realtime_Chronograph {
	int32_t classID;
} javax_realtime_Chronograph;

typedef struct javax_realtime_ConfigurationParameters {
	int32_t classID;
	int32_t messageLengthI;
	int32_t stackTraceLengthI;
	int32_t sizesLjava_lang_LongArray_;
} javax_realtime_ConfigurationParameters;

typedef struct javax_realtime_HighResolutionTime {
	int32_t classID;
	int32_t millisJ_msb;
	int32_t millisJ_lsb;
	int32_t nanosI;
} javax_realtime_HighResolutionTime;

typedef struct javax_realtime_MemoryArea {
	int32_t classID;
} javax_realtime_MemoryArea;

typedef struct javax_realtime_MemoryParameters {
	int32_t classID;
	int32_t maxInitialAreaJ_msb;
	int32_t maxInitialAreaJ_lsb;
	int32_t maxImmortalJ_msb;
	int32_t maxImmortalJ_lsb;
} javax_realtime_MemoryParameters;

typedef struct javax_realtime_PeriodicParameters {
	int32_t classID;
	int32_t startLjavax_realtime_RelativeTime_;
	int32_t periodLjavax_realtime_RelativeTime_;
	int32_t deadlineLjavax_realtime_RelativeTime_;
	int32_t missHandlerLjavax_realtime_AsyncEventHandler_;
} javax_realtime_PeriodicParameters;

typedef struct javax_realtime_PriorityParameters {
	int32_t classID;
	int32_t priorityI;
} javax_realtime_PriorityParameters;

typedef struct javax_realtime_PriorityScheduler {
	int32_t classID;
} javax_realtime_PriorityScheduler;

typedef struct javax_realtime_RelativeTime {
	int32_t classID;
	int32_t millisJ_msb;
	int32_t millisJ_lsb;
	int32_t nanosI;
} javax_realtime_RelativeTime;

typedef struct javax_realtime_Releasable {
	int32_t classID;
} javax_realtime_Releasable;

typedef struct javax_realtime_ReleaseParameters {
	int32_t classID;
} javax_realtime_ReleaseParameters;

typedef struct javax_realtime_Schedulable {
	int32_t classID;
} javax_realtime_Schedulable;

typedef struct javax_realtime_SchedulingParameters {
	int32_t classID;
} javax_realtime_SchedulingParameters;

typedef struct javax_realtime_Scheduler {
	int32_t classID;
} javax_realtime_Scheduler;

typedef struct javax_realtime_Timable {
	int32_t classID;
} javax_realtime_Timable;

typedef struct javax_realtime_memory_ScopedMemory {
	int32_t classID;
} javax_realtime_memory_ScopedMemory;

typedef struct javax_realtime_memory_ScopeParameters {
	int32_t classID;
	int32_t maxInitialAreaJ_msb;
	int32_t maxInitialAreaJ_lsb;
	int32_t maxImmortalJ_msb;
	int32_t maxImmortalJ_lsb;
	int32_t maxContainingAreaJ_msb;
	int32_t maxContainingAreaJ_lsb;
	int32_t maxInitialBackingStoreJ_msb;
	int32_t maxInitialBackingStoreJ_lsb;
} javax_realtime_memory_ScopeParameters;

typedef struct javax_realtime_memory_StackedMemory {
	int32_t classID;
} javax_realtime_memory_StackedMemory;

typedef struct javax_microedition_io_Connection {
	int32_t classID;
} javax_microedition_io_Connection;

typedef struct javax_microedition_io_InputConnection {
	int32_t classID;
} javax_microedition_io_InputConnection;

typedef struct javax_microedition_io_OutputConnection {
	int32_t classID;
} javax_microedition_io_OutputConnection;

typedef struct javax_microedition_io_StreamConnection {
	int32_t classID;
} javax_microedition_io_StreamConnection;

typedef struct java_lang_Array {
	int32_t classID;
} java_lang_Array;

typedef struct java_lang_Array1 {
	int32_t classID;
	int32_t value0Ljava_lang_Object_;
} java_lang_Array1;

typedef struct java_lang_Array2 {
	int32_t classID;
	int32_t value0Ljava_lang_Object_;
	int32_t value1Ljava_lang_Object_;
} java_lang_Array2;

typedef struct java_lang_Array3 {
	int32_t classID;
	int32_t value0Ljava_lang_Object_;
	int32_t value1Ljava_lang_Object_;
	int32_t value2Ljava_lang_Object_;
} java_lang_Array3;

typedef struct java_lang_Array4 {
	int32_t classID;
	int32_t value0Ljava_lang_Object_;
	int32_t value1Ljava_lang_Object_;
	int32_t value2Ljava_lang_Object_;
	int32_t value3Ljava_lang_Object_;
} java_lang_Array4;

typedef struct java_lang_Array5 {
	int32_t classID;
	int32_t value0Ljava_lang_Object_;
	int32_t value1Ljava_lang_Object_;
	int32_t value2Ljava_lang_Object_;
	int32_t value3Ljava_lang_Object_;
	int32_t value4Ljava_lang_Object_;
} java_lang_Array5;

typedef struct java_lang_BooleanArray {
	int32_t classID;
} java_lang_BooleanArray;

typedef struct java_lang_BooleanArray1 {
	int32_t classID;
	int32_t value0Z;
} java_lang_BooleanArray1;

typedef struct java_lang_BooleanArray2 {
	int32_t classID;
	int32_t value0Z;
	int32_t value1Z;
} java_lang_BooleanArray2;

typedef struct java_lang_BooleanArray3 {
	int32_t classID;
	int32_t value0Z;
	int32_t value1Z;
	int32_t value2Z;
} java_lang_BooleanArray3;

typedef struct java_lang_BooleanArray4 {
	int32_t classID;
	int32_t value0Z;
	int32_t value1Z;
	int32_t value2Z;
	int32_t value3Z;
} java_lang_BooleanArray4;

typedef struct java_lang_BooleanArray5 {
	int32_t classID;
	int32_t value0Z;
	int32_t value1Z;
	int32_t value2Z;
	int32_t value3Z;
	int32_t value4Z;
} java_lang_BooleanArray5;

typedef struct java_lang_Cloneable {
	int32_t classID;
} java_lang_Cloneable;

typedef struct java_lang_Comparable {
	int32_t classID;
} java_lang_Comparable;

typedef struct java_lang_IntArray {
	int32_t classID;
} java_lang_IntArray;

typedef struct java_lang_IntArray1 {
	int32_t classID;
	int32_t value0I;
} java_lang_IntArray1;

typedef struct java_lang_LongArray {
	int32_t classID;
} java_lang_LongArray;

typedef struct java_lang_LongArray1 {
	int32_t classID;
	int32_t value0J_msb;
	int32_t value0J_lsb;
} java_lang_LongArray1;

typedef struct java_lang_Object {
	int32_t classID;
} java_lang_Object;

typedef struct java_lang_String {
	int32_t classID;
	int32_t bytesLjava_lang_IntArray_;
} java_lang_String;

typedef struct java_io_Closeable {
	int32_t classID;
} java_io_Closeable;

typedef struct java_io_DataInputStream {
	int32_t classID;
	int32_t inLjava_io_InputStream_;
} java_io_DataInputStream;

typedef struct java_io_DataOutputStream {
	int32_t classID;
	int32_t outLjava_io_OutputStream_;
} java_io_DataOutputStream;

typedef struct java_io_Flushable {
	int32_t classID;
} java_io_Flushable;

typedef struct java_io_InputStream {
	int32_t classID;
} java_io_InputStream;

typedef struct java_io_OutputStream {
	int32_t classID;
} java_io_OutputStream;

typedef struct devices_Console {
	int32_t classID;
} devices_Console;

typedef struct javax_scj_util_Const {
	int32_t classID;
} javax_scj_util_Const;

typedef struct staticClassFieldsStruct {
	int32_t javax_safetycritical_PriorityScheduler_schedulerLjavax_safetycritical_PriorityScheduler_;
	int32_t javax_safetycritical_Safelet_INSUFFICIENT_BACKING_STOREJ;
	int32_t javax_safetycritical_Safelet_INSUFFICIENT_IMMORTAL_MEMORYJ;
	int32_t devices_Console_connLjavax_safetycritical_io_ConsoleConnection_;
	int32_t javax_scj_util_Const_OVERALL_BACKING_STOREI;
	int32_t javax_scj_util_Const_PRIVATE_BACKING_STOREI;
	int32_t javax_scj_util_Const_PRIVATE_MEMI;
	int32_t javax_scj_util_Const_MISSION_MEMI;
	int32_t javax_scj_util_Const_IMMORTAL_MEMI;
	int32_t javax_scj_util_Const_OUTERMOST_SEQ_BACKING_STOREI;
	int32_t javax_scj_util_Const_HANDLER_STACK_SIZEI;
} staticClassFieldsStruct;

