package javax.safetycritical;

import javax.realtime.memory.StackedMemory;

public abstract class ManagedMemory extends StackedMemory {
	public static void enterPrivateMemory(long size, Runnable logic) {
		enterPrivateMemory((int) size);
		logic.run();
		exitMemory();
	}
	
	private static native void enterPrivateMemory(int size);
	
	private static native void exitMemory();
	
	public static void executeInAreaOf(Object obj, Runnable logic) {
		executeInAreaOf(obj);
		logic.run();
		exitMemory();
	}
	
	private static native void executeInAreaOf(Object obj);
	
	public static void executeInOuterArea(Runnable logic) {
		executeInOuterArea();
		logic.run();
		exitMemory();
	}
	
	private static native void executeInOuterArea();
}
