package javax.realtime;

public abstract class HighResolutionTime<T extends HighResolutionTime<T>> implements Cloneable, Comparable<T> {
	
	private long millis;
	private int nanos;
	
	protected HighResolutionTime(long millis, int nanos, Chronograph clock) {
		this.millis = millis;
		this.nanos =  nanos;
	}
	
	public final long getMilliseconds() {
		return millis;
	}
	
	public final int getNanoseconds() {
		return nanos; 
	}
	
	public abstract boolean isRelative();
	
}
