package main;

import java.util.Objects;

public class FullMethodID {
	public final ClassID classID;
	public final MethodID methodID;
	
	public FullMethodID(ClassID classID, MethodID methodID){
		if (classID == null || methodID == null) {
			throw new IllegalArgumentException("classID and methodID must be non-null");
		}
		this.classID = classID;
		this.methodID = methodID;
	}
	
	public String toModelString() {
		return classID.toModelString() + "\\_" + methodID.toModelString();
	}
	
	@Override
	public String toString() {
		return this.toModelString();
	}
	
	@Override
	public int hashCode(){
		return Objects.hash(classID, methodID);
	}
	
	@Override
	public boolean equals(Object x) {
		if (x instanceof FullMethodID) {
			return (((FullMethodID) x).classID.equals(this.classID))
					&& (((FullMethodID) x).methodID.equals(this.methodID));
		}
		return false;
		
	}
	
}