package main;

import java.util.Objects;

public class ClassID {
	private final String classID;
	
	public ClassID(String classID){
		if (classID == null) {
			throw new IllegalArgumentException("classID must be non-null");
		}
		this.classID = classID.replace(".", "\\_").replace("/", "\\_").replace("$", "");
	}
	
	public String toModelString() {
		return classID;
	}
	
	@Override
	public String toString() {
		return this.toModelString();
	}
	
	@Override
	public int hashCode(){
		return Objects.hash(classID);
	}
	
	@Override
	public boolean equals(Object x) {
		if (x instanceof ClassID) {
			return (((ClassID) x).classID.equals(this.classID));
		}
		return false;
		
	}
}
