package main;

import javax.safetycritical.Mission;
import javax.safetycritical.MissionSequencer;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.StorageParameters;
import javax.scj.util.Const;
import javax.realtime.*;
//import javax.realtime.memory.ScopeParameters;


public class MainSequence extends MissionSequencer {
	
	public MainSequence() {

		super( new PriorityParameters(PriorityScheduler.instance().getMaxPriority()),
			   new StorageParameters(
					   Const.OUTERMOST_SEQ_BACKING_STORE,
					   Const.PRIVATE_MEM,
					   Const.IMMORTAL_MEM,
					   Const.MISSION_MEM),
			   new ConfigurationParameters(-1, -1, new long[] {Const.HANDLER_STACK_SIZE})
		     );
	}

	protected Mission getNextMission() {
		return new MainMission();  
	}

}
