package main;

import javax.realtime.AperiodicParameters;
import javax.realtime.ConfigurationParameters;
import javax.realtime.PriorityParameters;
import javax.safetycritical.AperiodicEventHandler;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.StorageParameters;
import javax.scj.util.Const;

import main.Buffer;

public class Consumer extends AperiodicEventHandler {

	/*
	 * Reference to MissionMemory
	 */
	private Buffer buffer;

	public Consumer(Buffer buffer) {
		
		super(//priority
			  new PriorityParameters(PriorityScheduler.instance().getMaxPriority()),
			  //release
			  new AperiodicParameters(),
			  //storage
			  new StorageParameters(
						Const.PRIVATE_BACKING_STORE,
						Const.PRIVATE_MEM,
						0, 0),
			  new ConfigurationParameters(-1, -1, new long[] {Const.HANDLER_STACK_SIZE}));
		
		this.buffer = buffer;
	}

	@Override
	public void handleAsyncEvent() {
		//System.out.println("** Consumer is now handling the 'consume' the event **");
		
		// System.out.println("3.1 ConsumerPrivate " + ((ManagedMemory) RealtimeThread.getCurrentMemoryArea()).toString());
		
		/*
		 * Get a reference to the new object
		 */
		Object data = buffer.get();

		/*
		 * Confirm we can use the object
		 */
		//System.out.println("3.2 Object.toString() : " + (data.toString()) + "\n");
		devices.Console.println(data.hashCode());
	}
}