package main;

import javax.safetycritical.Mission;


public class MainMission extends Mission {
	
	public long missionMemorySize() {
		return 1000000;
	}
	
	protected void initialize() {
		//System.out.println("Initializing main mission");
		
		/* 
		 * Signal is an AperiodicEvent with a state
		 * used for backwards propagation of information
		 * between the Worker and Producer
		 */
		PersistentSignal signal = new PersistentSignal();
		
		/*
		 * Create Worker APEH
		 * Pass a reference to the triggering event
		 * ManagedHandlers need to register themselves upon creation
		 */
		Worker worker = new Worker(signal);
		worker.register();
		
		/*
		 * Create Producer PEH
		 * Pass a reference to the event to be triggered
		 * ManagedHandlers need to register themselves upon creation
		 */
		(new Producer(signal, worker, 2000, 0)).register();
	}

}
