package main;

import javax.realtime.AperiodicParameters;
import javax.realtime.ConfigurationParameters;
import javax.realtime.PriorityParameters;
import javax.realtime.memory.ScopeParameters;
import javax.safetycritical.AperiodicEventHandler;
import javax.safetycritical.PriorityScheduler;
import javax.scj.util.Const;


public class Worker extends AperiodicEventHandler  {

	private PersistentSignal _signal;
	private int _iteration;

	public Worker(PersistentSignal event){
		super(
				new PriorityParameters(PriorityScheduler.instance().getMaxPriority()),
				new AperiodicParameters(),
				new ScopeParameters(
						Const.PRIVATE_BACKING_STORE,
						Const.PRIVATE_MEM,
						0, 0),
				new ConfigurationParameters(-1, -1, new LongArray1(Const.HANDLER_STACK_SIZE)));
		
		this._signal = event;
		this._iteration = 0;
	}

	// public PersistentSignal getSignal() {  return this._signal;  }

	public void handleAsyncEvent() {
		/* do work */
		this._iteration++;
		//System.out.println("  2 Worker - output iteration: " + this._iteration + "  ");
		devices.Console.write(-2);
		devices.Console.write(this._iteration);
		
		/* Work done, set signal */
		this._signal.set();		
	}

}
