package javax.safetycritical;

import javax.realtime.AbsoluteTime;
import javax.realtime.AperiodicParameters;
import javax.realtime.ConfigurationParameters;
import javax.realtime.HighResolutionTime;
import javax.realtime.PriorityParameters;
import javax.realtime.RelativeTime;
import javax.realtime.memory.ScopeParameters;

public abstract class OneShotEventHandler extends ManagedEventHandler {

	private int start;
	
	public OneShotEventHandler(PriorityParameters priority,
			AbsoluteTime time,
			AperiodicParameters release,
			ScopeParameters storage,
			ConfigurationParameters config) {
		super(priority, storage, config);
		
		this.start = (int) (time.getMilliseconds() + time.getNanoseconds());
		
		initOSEHAbs(this,
				this.priority,
				this.start,
				this.backingStoreSpace,
				this.allocAreaSpace,
				this.stackSize);
	}
	
	private static native void initOSEHAbs(
			OneShotEventHandler oseh, 
			int priority, 
			int startTime, 
			int bsSize, 
			int areaSize, 
			int stackSize);
	
	public OneShotEventHandler(PriorityParameters priority,
			RelativeTime time,
			AperiodicParameters release,
			ScopeParameters storage,
			ConfigurationParameters config) {
		super(priority, storage, config);
		
		this.start = ((int) time.getMilliseconds()) + time.getNanoseconds();
		
		initOSEHRel(this,
				this.priority,
				this.start,
				this.backingStoreSpace,
				this.allocAreaSpace,
				this.stackSize);
	}
	
	private static native void initOSEHRel(
			OneShotEventHandler oseh, 
			int priority, 
			int startTime, 
			int bsSize, 
			int areaSize, 
			int stackSize);
}
