package javax.safetycritical;

import javax.realtime.BoundAsyncEventHandler;
import javax.realtime.ConfigurationParameters;
import javax.realtime.PriorityParameters;
import javax.realtime.memory.ScopeParameters;

public abstract class ManagedEventHandler extends BoundAsyncEventHandler implements ManagedSchedulable {
	
	protected int priority;
	protected int backingStoreSpace;
	protected int allocAreaSpace;
	protected int stackSize;
	
	protected ManagedEventHandler(PriorityParameters priority,
			ScopeParameters storage,
			ConfigurationParameters config) {
		this.priority = priority.getPriority();
		this.backingStoreSpace = (int) storage.getMaxInitialBackingStore();
		this.allocAreaSpace = (int) storage.getMaxInitialArea();
		this.stackSize = (int) config.getSizes().load(0);
	}
	
	public void cleanUp() {}
	
//	public String getName() {
//		return null;
//	}
	
	public void register() {
		register(this);
	}
	
	private static native void register(ManagedEventHandler obj);
	
	public void signalTermination() {}
}
