package javax.realtime;

public class PeriodicParameters extends ReleaseParameters {
	
	private RelativeTime start;
	private RelativeTime period;
	private RelativeTime deadline;
	private AsyncEventHandler missHandler;
	
	public PeriodicParameters(RelativeTime start,
			RelativeTime period,
			RelativeTime deadline,
			AsyncEventHandler missHandler) {
		this.start = start;
		this.period = period;
		this.deadline = deadline;
		this.missHandler = missHandler;
	}
	
	public PeriodicParameters(RelativeTime start, RelativeTime period) {
		this(start, period, null, null);
	}

	public RelativeTime getStart() {
		return start;
	}

	public RelativeTime getPeriod() {
		return period;
	}
	
	public RelativeTime getDeadline() {
		return deadline;
	}
	
	public AsyncEventHandler getMissHandler() {
		return missHandler;
	}
}
