package main;

public abstract class CPEntry {

	private CPEntry() {} // prevent further extension of this class
	
	public abstract String toModelString();
	
	public static final class ClassRef extends CPEntry {
		private ClassID classID;
		
		public ClassRef(ClassID classID) {
			this.classID = classID;
		}

		@Override
		public String toModelString() {
			return "ClassRef~" + classID;
		}

		public ClassID getClassID() {
			return classID;
		}
	}
	public static final class MethodRef extends CPEntry {
		private ClassID classID;
		private MethodID methodID;
		
		public MethodRef(ClassID classID, MethodID methodID) {
			this.classID = classID;
			this.methodID = methodID;
		}

		@Override
		public String toModelString() {
			return "MethodRef~" + classID + "~" + methodID;
		}

		public ClassID getClassID() {
			return classID;
		}

		public MethodID getMethodID() {
			return methodID;
		}
		
		public FullMethodID getFullID() {
			return new FullMethodID(classID, methodID);
		}
	}
	public static final class FieldRef extends CPEntry {
		private ClassID classID;
		private FieldID fieldID;
		
		public FieldRef(ClassID classID, FieldID fieldID) {
			this.classID = classID;
			this.fieldID = fieldID;
		}

		@Override
		public String toModelString() {
			return "FieldRef~" + classID + "~" + fieldID;
		}

		public ClassID getClassID() {
			return classID;
		}

		public FieldID getFieldID() {
			return fieldID;
		}
	}
}
