package main;

import javax.safetycritical.Mission;


public class MainMission extends Mission {
	
	public long missionMemorySize() {
		return 1000000;
	}
	
	protected void initialize() {
		//System.out.println("Initializing main mission");
		
		/*
		 * The Shared Buffer is created in MissionMemory
		 */
		Buffer buffer = new BoundedBuffer();
	    
		/*
		 * Create Consumer AEH
		 * Pass a reference to the shared buffer
		 * ManagedHandlers need to be registered
		 */
		Consumer consumer = new Consumer(buffer);
		consumer.register();
		
		/*
		 * Create Producer PEH
		 * Pass a reference to the consumer and the shared buffer
		 * ManagedHandlers need to be registered
		 */
		(new Producer(consumer,buffer)).register();
	}

}
