package main;

import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.Services;

public class BoundedBuffer implements Buffer {

	// indices to keep track of the valid internal references
	private int first;
	private int last;
	// number of items stored
	private int stored;
	// maximum number of items stored
	private int max = 5;
	// the array to store the references
	private Object[] data;

	public BoundedBuffer() {
		
		/*
		 * Set the ceiling priority for this shared object
		 * used by Priority Ceiling Emulation protocol
		 * Consumer is at max priority
		 */
		
		Services.setCeiling(this,
					PriorityScheduler.instance().getMaxPriority());
		
        this.data = new Object[ this.max ];
        this.first = 0;
        this.last = 0;
        this.stored = 0;
    }

    public synchronized void put(Object item) { 
                // check if buffer is not full
                // Do nothing if we are already full
                if ( this.stored == this.max ) return;  
                this.last = ( this.last + 1 ) % this.max; 
                this.stored++;
                this.data[last] = item;
        }	

    public synchronized Object get() { 
                // check if empty
                if ( this.stored == 0 ) return null;
                this.first = (this.first + 1) % this.max;
                this.stored--;
                return this.data[first]; 
        }

    public synchronized boolean isFull() { return this.stored == this.max; }
}
