#ifndef ROBOCALC_ROBOTS_EPUCK_H_
#define ROBOCALC_ROBOTS_EPUCK_H_

#include "IMotionControl.h"
#include "INeighbourWatchOps.h"
#include "IGoalWatchOps.h"
#include "IObjectWatchOps.h"
#include "IObjectWatch.h"
#include "IGoalWatch.h"
#include "INeighbourWatch.h"

class ePuck: public IMotionControl, public INeighbourWatchOps, public IGoalWatchOps, public IObjectWatchOps, public IObjectWatch, public IGoalWatch, public INeighbourWatch {
public:
	ePuck(
		std::shared_ptr<robochart::objectSeen_channel> objectSeen,
		std::shared_ptr<robochart::goalSeen_channel> goalSeen,
		std::shared_ptr<robochart::neighbourDetected_channel> neighbourDetected);
	virtual ~ePuck();
	void Sensors();
	void Actuators();
private:
	std::shared_ptr<robochart::objectSeen_channel> objectSeen;
private:
	std::shared_ptr<robochart::goalSeen_channel> goalSeen;
private:
	std::shared_ptr<robochart::neighbourDetected_channel> neighbourDetected;

public:
    int robot_id;

};

#endif
